/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.NameValue;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

public class GO_GenericName
extends XmlAdapter<GO_GenericName, GenericName> {
    private GenericName name;

    public GO_GenericName() {
    }

    private GO_GenericName(GenericName value) {
        this.name = value;
    }

    public GO_GenericName marshal(GenericName value) {
        return value != null ? new GO_GenericName(value) : null;
    }

    public final GenericName unmarshal(GO_GenericName value) {
        return value != null ? value.name : null;
    }

    @XmlElementRef
    public final NameValue getValue() {
        NameValue code;
        GenericName name = this.name;
        if (name instanceof LocalName) {
            if (name instanceof TypeName || name instanceof MemberName) {
                return null;
            }
            code = FilterByVersion.LEGACY_METADATA.accept() ? new NameValue.Local() : new NameValue.Scoped();
        } else if (name instanceof ScopedName) {
            code = new NameValue.Scoped();
        } else {
            return null;
        }
        code.setName(name);
        return code;
    }

    @XmlElementRef
    public final DefaultLocalName getName() {
        GenericName name = this.name;
        if (name instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)name);
        }
        if (name instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)name);
        }
        return null;
    }

    public final void setValue(NameValue code) throws IllegalStateException {
        this.ensureUndefined();
        if (code != null) {
            this.name = code.getName();
        }
    }

    public final void setName(DefaultLocalName value) throws IllegalStateException {
        this.ensureUndefined();
        this.name = value;
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.name != null) {
            throw new IllegalStateException(Errors.format((short)164, "name"));
        }
    }

    public static final class Since2014
    extends GO_GenericName {
        @Override
        public GO_GenericName marshal(GenericName value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

