/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.opengis.metadata.MetadataScope;

abstract class MetadataScopeAdapter<L>
extends LegacyPropertyAdapter<L, MetadataScope> {
    MetadataScopeAdapter(Collection<MetadataScope> scopes) {
        super(scopes);
    }

    @Override
    public boolean add(L newValue) {
        int n = 0;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            MetadataScope scope = (MetadataScope)it.next();
            if (this.unwrap(scope) != null) {
                ++n;
                continue;
            }
            if (!(scope instanceof DefaultMetadataScope) || ((DefaultMetadataScope)scope).state() == ModifiableMetadata.State.FINAL) {
                scope = new DefaultMetadataScope(scope);
                if (this.elements instanceof List) {
                    ((List)this.elements).set(n, scope);
                } else {
                    MetadataScope[] remaining = new MetadataScope[this.elements.size() - n];
                    remaining[0] = scope;
                    n = 1;
                    it.remove();
                    while (it.hasNext()) {
                        remaining[n++] = (MetadataScope)it.next();
                        it.remove();
                    }
                    if (n != remaining.length) {
                        throw new ConcurrentModificationException();
                    }
                    Collections.addAll(this.elements, remaining);
                }
            }
            return this.update(scope, newValue);
        }
        return super.add(newValue);
    }
}

