/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Series_Type", propOrder={"name", "issueIdentification", "page"})
@XmlRootElement(name="CI_Series")
public class DefaultSeries
extends ISOMetadata
implements Series {
    private static final long serialVersionUID = -1584743260325409070L;
    private InternationalString name;
    private InternationalString issueIdentification;
    private InternationalString page;

    public DefaultSeries() {
    }

    public DefaultSeries(CharSequence name) {
        this.name = Types.toInternationalString(name);
    }

    public DefaultSeries(Series object) {
        super(object);
        if (object != null) {
            this.name = object.getName();
            this.issueIdentification = object.getIssueIdentification();
            this.page = object.getPage();
        }
    }

    public static DefaultSeries castOrCopy(Series object) {
        if (object == null || object instanceof DefaultSeries) {
            return (DefaultSeries)object;
        }
        return new DefaultSeries(object);
    }

    @XmlElement(name="name")
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString newValue) {
        this.checkWritePermission(this.name);
        this.name = newValue;
    }

    @XmlElement(name="issueIdentification")
    public InternationalString getIssueIdentification() {
        return this.issueIdentification;
    }

    public void setIssueIdentification(InternationalString newValue) {
        this.checkWritePermission(this.issueIdentification);
        this.issueIdentification = newValue;
    }

    @XmlElement(name="page")
    public InternationalString getPage() {
        return this.page;
    }

    public void setPage(InternationalString newValue) {
        this.checkWritePermission(this.page);
        this.page = newValue;
    }
}

