/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.net.URI;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.KeywordClass;
import org.opengis.util.InternationalString;

@TitleProperty(name="className")
@XmlType(name="MD_KeywordClass_Type", propOrder={"className", "conceptIdentifier", "ontology"})
@XmlRootElement(name="MD_KeywordClass")
public class DefaultKeywordClass
extends ISOMetadata
implements KeywordClass {
    private static final long serialVersionUID = 5353835680916000713L;
    private InternationalString className;
    private URI conceptIdentifier;
    private Citation ontology;

    public DefaultKeywordClass() {
    }

    public DefaultKeywordClass(CharSequence className, Citation ontology) {
        this.className = Types.toInternationalString(className);
        this.ontology = ontology;
    }

    public DefaultKeywordClass(KeywordClass object) {
        super(object);
        if (object != null) {
            this.className = object.getClassName();
            this.conceptIdentifier = object.getConceptIdentifier();
            this.ontology = object.getOntology();
        }
    }

    public static DefaultKeywordClass castOrCopy(KeywordClass object) {
        if (object == null || object instanceof DefaultKeywordClass) {
            return (DefaultKeywordClass)object;
        }
        return new DefaultKeywordClass(object);
    }

    @XmlElement(name="className", required=true)
    public InternationalString getClassName() {
        return this.className;
    }

    public void setClassName(InternationalString newValue) {
        this.checkWritePermission(this.className);
        this.className = newValue;
    }

    @XmlElement(name="conceptIdentifier")
    public URI getConceptIdentifier() {
        return this.conceptIdentifier;
    }

    public void setConceptIdentifier(URI newValue) {
        this.checkWritePermission(this.conceptIdentifier);
        this.conceptIdentifier = newValue;
    }

    @XmlElement(name="ontology", required=true)
    public Citation getOntology() {
        return this.ontology;
    }

    public void setOntology(Citation newValue) {
        this.checkWritePermission(this.ontology);
        this.ontology = newValue;
    }
}

