/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.InternationalStringAdapter;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.legacy.DateToTemporal;
import org.apache.sis.internal.metadata.legacy.TemporalToDate;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.quality.AbstractCompleteness;
import org.apache.sis.metadata.iso.quality.AbstractLogicalConsistency;
import org.apache.sis.metadata.iso.quality.AbstractMetaquality;
import org.apache.sis.metadata.iso.quality.AbstractPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.AbstractTemporalQuality;
import org.apache.sis.metadata.iso.quality.AbstractThematicAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultEvaluationMethod;
import org.apache.sis.metadata.iso.quality.DefaultMeasureReference;
import org.apache.sis.metadata.iso.quality.DefaultQualityMeasure;
import org.apache.sis.metadata.iso.quality.DefaultUsability;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.collection.Containers;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.Completeness;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.EvaluationMethod;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.LogicalConsistency;
import org.opengis.metadata.quality.MeasureReference;
import org.opengis.metadata.quality.Metaquality;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.Result;
import org.opengis.metadata.quality.TemporalQuality;
import org.opengis.metadata.quality.ThematicAccuracy;
import org.opengis.metadata.quality.Usability;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDQ_Element_Type", propOrder={"standaloneQualityReportDetails", "measureReference", "evaluationMethod", "namesOfMeasure", "measureIdentification", "measureDescription", "evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "dates", "results", "derivedElement"})
@XmlRootElement(name="AbstractDQ_Element")
@XmlSeeAlso(value={AbstractCompleteness.class, AbstractLogicalConsistency.class, AbstractPositionalAccuracy.class, AbstractThematicAccuracy.class, AbstractTemporalQuality.class, DefaultUsability.class, AbstractMetaquality.class, DefaultQualityMeasure.class})
public class AbstractElement
extends ISOMetadata
implements Element {
    private static final long serialVersionUID = -406229448295586970L;
    private InternationalString standaloneQualityReportDetails;
    private MeasureReference measureReference;
    private EvaluationMethod evaluationMethod;
    private Collection<Result> results;
    private Collection<Element> derivedElements;

    public AbstractElement() {
    }

    public AbstractElement(Result result) {
        this.results = this.singleton(result, Result.class);
    }

    public AbstractElement(Element object) {
        super(object);
        if (object != null) {
            DefaultMeasureReference candidate;
            this.standaloneQualityReportDetails = object.getStandaloneQualityReportDetails();
            this.measureReference = object.getMeasureReference();
            if (this.measureReference == null && (candidate = new DefaultMeasureReference()).setLegacy(object)) {
                this.measureReference = candidate;
            }
            this.evaluationMethod = object.getEvaluationMethod();
            this.results = this.copyCollection(object.getResults(), Result.class);
            this.derivedElements = this.copyCollection(object.getDerivedElements(), Element.class);
        }
    }

    public static AbstractElement castOrCopy(Element object) {
        if (object instanceof PositionalAccuracy) {
            return AbstractPositionalAccuracy.castOrCopy((PositionalAccuracy)object);
        }
        if (object instanceof TemporalQuality) {
            return AbstractTemporalQuality.castOrCopy((TemporalQuality)object);
        }
        if (object instanceof ThematicAccuracy) {
            return AbstractThematicAccuracy.castOrCopy((ThematicAccuracy)object);
        }
        if (object instanceof LogicalConsistency) {
            return AbstractLogicalConsistency.castOrCopy((LogicalConsistency)object);
        }
        if (object instanceof Completeness) {
            return AbstractCompleteness.castOrCopy((Completeness)object);
        }
        if (object instanceof Usability) {
            return DefaultUsability.castOrCopy((Usability)object);
        }
        if (object instanceof Metaquality) {
            return AbstractMetaquality.castOrCopy((Metaquality)object);
        }
        if (object == null || object instanceof AbstractElement) {
            return (AbstractElement)object;
        }
        return new AbstractElement(object);
    }

    @XmlElement(name="standaloneQualityReportDetails")
    @XmlJavaTypeAdapter(value=InternationalStringAdapter.Since2014.class)
    public InternationalString getStandaloneQualityReportDetails() {
        return this.standaloneQualityReportDetails;
    }

    public void setStandaloneQualityReportDetails(InternationalString newValue) {
        this.checkWritePermission(this.standaloneQualityReportDetails);
        this.standaloneQualityReportDetails = newValue;
    }

    @XmlElement(name="measure", required=false)
    public MeasureReference getMeasureReference() {
        return this.measureReference != null ? this.measureReference : super.getMeasureReference();
    }

    public void setMeasureReference(MeasureReference newValues) {
        this.checkWritePermission(this.measureReference);
        this.measureReference = newValues;
    }

    private <V> V getMeasureReferenceProperty(Function<MeasureReference, V> getter) {
        MeasureReference m = this.getMeasureReference();
        return m != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)getter.apply(m) : null;
    }

    private <V> void setMeasureReferenceProperty(BiConsumer<DefaultMeasureReference, V> setter, V newValue) {
        if (newValue != null) {
            if (!(this.measureReference instanceof DefaultMeasureReference)) {
                this.measureReference = new DefaultMeasureReference(this.measureReference);
            }
            setter.accept((DefaultMeasureReference)this.measureReference, newValue);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="nameOfMeasure", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<InternationalString> getNamesOfMeasure() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        MeasureReference m = this.getMeasureReference();
        if (m == null) {
            if (this.state() == ModifiableMetadata.State.FINAL) {
                return Collections.emptyList();
            }
            m = new DefaultMeasureReference();
            this.setMeasureReference(m);
        }
        if (m instanceof DefaultMeasureReference) {
            return ((DefaultMeasureReference)m).getNamesOfMeasure();
        }
        return Collections.unmodifiableCollection(m.getNamesOfMeasure());
    }

    @Deprecated(since="1.3")
    public void setNamesOfMeasure(Collection<? extends InternationalString> newValues) {
        if (!Containers.isNullOrEmpty(newValues)) {
            this.setMeasureReferenceProperty(DefaultMeasureReference::setNamesOfMeasure, newValues);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureIdentification", namespace="http://www.isotc211.org/2005/gmd")
    public Identifier getMeasureIdentification() {
        return this.getMeasureReferenceProperty(MeasureReference::getMeasureIdentification);
    }

    @Deprecated(since="1.3")
    public void setMeasureIdentification(Identifier newValue) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureIdentification, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getMeasureReference"})
    @XmlElement(name="measureDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getMeasureDescription() {
        return this.getMeasureReferenceProperty(MeasureReference::getMeasureDescription);
    }

    @Deprecated(since="1.3")
    public void setMeasureDescription(InternationalString newValue) {
        this.setMeasureReferenceProperty(DefaultMeasureReference::setMeasureDescription, newValue);
    }

    @XmlElement(name="evaluationMethod", required=false)
    public EvaluationMethod getEvaluationMethod() {
        return this.evaluationMethod;
    }

    public void setEvaluationMethod(EvaluationMethod newValue) {
        this.checkWritePermission(this.evaluationMethod);
        this.evaluationMethod = newValue;
    }

    private <V> V getEvaluationMethodProperty(Function<EvaluationMethod, V> getter) {
        EvaluationMethod m = this.getEvaluationMethod();
        return m != null && FilterByVersion.LEGACY_METADATA.accept() ? (V)getter.apply(m) : null;
    }

    private <V> void setEvaluationMethodProperty(BiConsumer<DefaultEvaluationMethod, V> setter, V newValue) {
        if (newValue != null) {
            if (!(this.evaluationMethod instanceof DefaultEvaluationMethod)) {
                this.evaluationMethod = new DefaultEvaluationMethod(this.evaluationMethod);
            }
            setter.accept((DefaultEvaluationMethod)this.evaluationMethod, newValue);
        }
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodType", namespace="http://www.isotc211.org/2005/gmd")
    public EvaluationMethodType getEvaluationMethodType() {
        return this.getEvaluationMethodProperty(EvaluationMethod::getEvaluationMethodType);
    }

    @Deprecated(since="1.3")
    public void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodType, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationMethodDescription", namespace="http://www.isotc211.org/2005/gmd")
    public InternationalString getEvaluationMethodDescription() {
        return this.getEvaluationMethodProperty(EvaluationMethod::getEvaluationMethodDescription);
    }

    @Deprecated(since="1.3")
    public void setEvaluationMethodDescription(InternationalString newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationMethodDescription, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="evaluationProcedure", namespace="http://www.isotc211.org/2005/gmd")
    public Citation getEvaluationProcedure() {
        return this.getEvaluationMethodProperty(EvaluationMethod::getEvaluationProcedure);
    }

    @Deprecated(since="1.3")
    public void setEvaluationProcedure(Citation newValue) {
        this.setEvaluationMethodProperty(DefaultEvaluationMethod::setEvaluationProcedure, newValue);
    }

    @Deprecated(since="1.3")
    @Dependencies(value={"getEvaluationMethod"})
    @XmlElement(name="dateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Date> getDates() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            Collection dates;
            EvaluationMethod m = this.getEvaluationMethod();
            if (m == null) {
                if (this.state() == ModifiableMetadata.State.FINAL) {
                    return Collections.emptyList();
                }
                m = new DefaultEvaluationMethod();
                this.setEvaluationMethod(m);
            }
            if ((dates = m.getDates()) != null) {
                return new TemporalToDate(dates);
            }
        }
        return null;
    }

    @Deprecated(since="1.3")
    public void setDates(Collection<? extends Date> newValues) {
        if (!Containers.isNullOrEmpty(newValues)) {
            this.setEvaluationMethodProperty(DefaultEvaluationMethod::setDates, new DateToTemporal(newValues));
        }
    }

    @XmlElement(name="result", required=true)
    public Collection<Result> getResults() {
        this.results = this.nonNullCollection(this.results, Result.class);
        return this.results;
    }

    public void setResults(Collection<? extends Result> newValues) {
        this.results = this.writeCollection(newValues, this.results, Result.class);
    }

    public Collection<Element> getDerivedElements() {
        this.derivedElements = this.nonNullCollection(this.derivedElements, Element.class);
        return this.derivedElements;
    }

    public void setDerivedElements(Collection<? extends Element> newValues) {
        this.derivedElements = this.writeCollection(newValues, this.derivedElements, Element.class);
    }

    @XmlElement(name="derivedElement")
    private Collection<Element> getDerivedElement() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDerivedElements() : null;
    }
}

