/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.util.Acyclic;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeNodeList;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Errors;

public class DefaultTreeTable
implements TreeTable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7991792044044382191L;
    private TreeTable.Node root;
    private transient List<TableColumn<?>> columns;
    final Map<TableColumn<?>, Integer> columnIndices;

    DefaultTreeTable(Map<TableColumn<?>, Integer> columnIndices) {
        this.columnIndices = columnIndices;
    }

    public DefaultTreeTable(TableColumn<?> ... columns) {
        ArgumentChecks.ensureNonEmpty("columns", columns);
        columns = (TableColumn[])Arrays.copyOf(columns, columns.length, TableColumn[].class);
        this.columnIndices = DefaultTreeTable.createColumnIndices(columns);
        this.columns = UnmodifiableArrayList.wrap(columns);
    }

    public DefaultTreeTable(Node root) {
        ArgumentChecks.ensureNonNull("root", root);
        this.root = root;
        this.columnIndices = root.columnIndices;
    }

    static Map<TableColumn<?>, Integer> createColumnIndices(TableColumn<?>[] columns) {
        Map<TableColumn<?>, Integer> map;
        switch (columns.length) {
            case 0: {
                map = Map.of();
                break;
            }
            case 1: {
                map = null;
                break;
            }
            default: {
                map = new LinkedHashMap(Containers.hashMapCapacity(columns.length));
            }
        }
        for (int i = 0; i < columns.length; ++i) {
            TableColumn<?> column = columns[i];
            ArgumentChecks.ensureNonNullElement("columns", i, column);
            Integer pos = i;
            if (map == null) {
                map = Map.of(column, pos);
                continue;
            }
            if (map.put(column, pos) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)25, column));
        }
        return map;
    }

    static TableColumn<?>[] getColumns(Map<TableColumn<?>, Integer> columnIndices) {
        return (TableColumn[])columnIndices.keySet().toArray(TableColumn[]::new);
    }

    @Override
    public final List<TableColumn<?>> getColumns() {
        if (this.columns == null) {
            this.columns = UnmodifiableArrayList.wrap(DefaultTreeTable.getColumns(this.columnIndices));
        }
        return this.columns;
    }

    @Override
    public TreeTable.Node getRoot() {
        if (this.root == null) {
            this.root = new Node(this);
            this.initialize(this.root);
        }
        return this.root;
    }

    public void setRoot(TreeTable.Node root) {
        Map<TableColumn<?>, Integer> other;
        ArgumentChecks.ensureNonNull("root", root);
        if (root instanceof Node && (other = ((Node)root).columnIndices) != this.columnIndices && !this.columnIndices.keySet().containsAll(other.keySet())) {
            throw new IllegalArgumentException(Errors.format((short)69));
        }
        this.root = root;
    }

    protected void initialize(TreeTable.Node root) {
    }

    public DefaultTreeTable clone() throws CloneNotSupportedException {
        DefaultTreeTable clone = (DefaultTreeTable)super.clone();
        clone.root = (TreeTable.Node)Cloner.cloneIfPublic(clone.root);
        return clone;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            DefaultTreeTable that = (DefaultTreeTable)other;
            return this.columnIndices.equals(that.columnIndices) && Objects.equals(this.getRoot(), that.getRoot());
        }
        return false;
    }

    public int hashCode() {
        return this.columnIndices.hashCode() + 31 * Objects.hashCode(this.getRoot()) ^ 0x900EEFEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TreeTableFormat treeTableFormat = TreeTableFormat.INSTANCE;
        synchronized (treeTableFormat) {
            return TreeTableFormat.INSTANCE.format(this);
        }
    }

    @Acyclic
    public static class Node
    implements TreeTable.Node,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -5729029633479218691L;
        private TreeTable.Node parent;
        private List<TreeTable.Node> children;
        final Map<TableColumn<?>, Integer> columnIndices;
        private Object[] values;

        public Node(TreeTable table) {
            ArgumentChecks.ensureNonNull("table", table);
            if (table instanceof DefaultTreeTable) {
                this.columnIndices = ((DefaultTreeTable)table).columnIndices;
            } else {
                List<TableColumn<?>> columns = table.getColumns();
                this.columnIndices = DefaultTreeTable.createColumnIndices((TableColumn[])columns.toArray(TableColumn[]::new));
            }
        }

        public Node(Node parent) {
            ArgumentChecks.ensureNonNull("parent", parent);
            this.parent = parent;
            this.columnIndices = parent.columnIndices;
            TreeNodeList addTo = (TreeNodeList)parent.getChildren();
            addTo.addChild(addTo.size(), this);
        }

        public Node(Node parent, int index) {
            ArgumentChecks.ensureNonNull("parent", parent);
            this.parent = parent;
            this.columnIndices = parent.columnIndices;
            TreeNodeList addTo = (TreeNodeList)parent.getChildren();
            ArgumentChecks.ensureValidIndex(addTo.size() + 1, index);
            addTo.addChild(index, this);
        }

        public Node(CharSequence name) {
            this.columnIndices = TableColumn.NAME_MAP;
            if (name != null) {
                this.values = new CharSequence[]{name};
            }
        }

        @Override
        public final TreeTable.Node getParent() {
            return this.parent;
        }

        final void setParent(TreeTable.Node node) {
            Map<TableColumn<?>, Integer> other;
            if (node instanceof Node && (other = ((Node)node).columnIndices) != this.columnIndices && !other.keySet().containsAll(this.columnIndices.keySet())) {
                throw new IllegalArgumentException(Errors.format((short)69));
            }
            this.parent = node;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public final List<TreeTable.Node> getChildren() {
            if (this.children == null) {
                this.children = this.isLeaf() ? List.of() : new Children(this);
            }
            return this.children;
        }

        @Override
        public Node newChild() {
            if (this.isLeaf()) {
                throw new UnsupportedOperationException(Errors.format((short)99, this));
            }
            return new Node(this);
        }

        @Override
        public <V> V getValue(TableColumn<V> column) {
            Integer index;
            ArgumentChecks.ensureNonNull("column", column);
            if (this.values != null && (index = this.columnIndices.get(column)) != null) {
                return column.getElementType().cast(this.values[index]);
            }
            return null;
        }

        @Override
        public <V> void setValue(TableColumn<V> column, V value) throws IllegalArgumentException {
            ArgumentChecks.ensureNonNull("column", column);
            Integer index = this.columnIndices.get(column);
            if (index == null) {
                throw new IllegalArgumentException(Errors.format((short)45, "column", column));
            }
            if (this.values == null) {
                if (value == null) {
                    return;
                }
                this.values = new Object[this.columnIndices.size()];
            }
            this.values[index.intValue()] = value;
        }

        @Override
        public boolean isEditable(TableColumn<?> column) {
            ArgumentChecks.ensureNonNull("column", column);
            return this.columnIndices.containsKey(column);
        }

        @Override
        public Object getUserObject() {
            return null;
        }

        public Node clone() throws CloneNotSupportedException {
            Node clone = (Node)super.clone();
            clone.parent = null;
            if (clone.values != null) {
                clone.values = (Object[])clone.values.clone();
            }
            if (clone.children != null) {
                clone.children = new Children(clone);
                for (TreeTable.Node child : this.children) {
                    if (!(child instanceof Node)) {
                        throw new CloneNotSupportedException(Errors.format((short)20, child.getClass()));
                    }
                    clone.children.add(((Node)child).clone());
                }
            }
            return clone;
        }

        @Override
        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other != null && other.getClass() == this.getClass()) {
                Node that = (Node)other;
                if (this.columnIndices.equals(that.columnIndices)) {
                    List<TreeTable.Node> c1;
                    int n;
                    List<TreeTable.Node> c2;
                    Object[] v1 = this.values;
                    Object[] v2 = that.values;
                    if (v1 != v2) {
                        int i = this.columnIndices.size();
                        while (--i >= 0) {
                            if (Objects.equals(v1 != null ? v1[i] : null, v2 != null ? v2[i] : null)) continue;
                            return false;
                        }
                    }
                    if (((c2 = that.children) != null ? c2.size() : 0) == (n = (c1 = this.children) != null ? c1.size() : 0)) {
                        for (int i = 0; i < n; ++i) {
                            if (c1.get(i).equals(c2.get(i))) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            Object[] values = this.values;
            if (values != null) {
                int i = values.length;
                while (--i >= 0) {
                    hash = 31 * hash + Objects.hashCode(values[i]);
                }
            }
            if (!Containers.isNullOrEmpty(this.children)) {
                hash += 37 * this.children.hashCode();
            }
            return hash ^ 0xECC8E9FD;
        }

        public String toString() {
            Collection<TreeTable.Node> children;
            Object[] values = this.values;
            if (values != null) {
                for (Object value : values) {
                    String text;
                    if (!(value instanceof CharSequence) || (text = value.toString()) == null || (text = text.strip()).isEmpty()) continue;
                    return text;
                }
            }
            Object name = this.getClass().getSimpleName();
            if (this.parent != null && (children = this.parent.getChildren()) instanceof List) {
                name = (String)name + "-" + ((List)children).indexOf(this);
            }
            return name;
        }

        private static final class Children
        extends TreeNodeList {
            private static final long serialVersionUID = -1543888535672160884L;

            Children(TreeTable.Node parent) {
                super(parent);
            }

            @Override
            protected void setParentOf(TreeTable.Node node, int mode) throws IllegalArgumentException {
                TreeTable.Node p;
                if (!(node instanceof Node)) {
                    throw new IllegalArgumentException(Errors.format((short)43, "node", Node.class, node.getClass()));
                }
                switch (mode) {
                    case 0: {
                        p = null;
                        break;
                    }
                    case 1: {
                        p = this.parent;
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new AssertionError(mode);
                    }
                }
                ((Node)node).setParent(p);
            }
        }
    }
}

