/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureAssociationRole;
import org.opengis.feature.InvalidPropertyValueException;

final class SingletonAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = -5247767277033831214L;
    private Feature value;

    public SingletonAssociation(FeatureAssociationRole role) {
        super(role);
        assert (SingletonAssociation.isSingleton(role.getMaximumOccurs()));
    }

    SingletonAssociation(FeatureAssociationRole role, Feature value) {
        super(role);
        assert (SingletonAssociation.isSingleton(role.getMaximumOccurs()));
        this.value = value;
        if (value != null) {
            this.ensureValid(role.getValueType(), value.getType());
        }
    }

    @Override
    public Feature getValue() {
        return this.value;
    }

    @Override
    public void setValue(Feature value) throws InvalidPropertyValueException {
        if (value != null) {
            this.ensureValid(this.role.getValueType(), value.getType());
        }
        this.value = value;
    }

    public int hashCode() {
        return this.role.hashCode() + Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SingletonAssociation) {
            SingletonAssociation that = (SingletonAssociation)obj;
            return this.role.equals((Object)that.role) && Objects.equals(this.value, that.value);
        }
        return false;
    }
}

