/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import org.apache.sis.image.BandSharedRaster;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;

abstract class BandSharing {
    protected final int[] offsets;
    private final BandedSampleModel target;
    private Raster[] parents;
    private int[] sourceTileIndices;

    protected BandSharing(BandedSampleModel target) {
        this.target = target;
        this.offsets = new int[target.getNumBands()];
    }

    static BandSharing create(BandedSampleModel target) {
        switch (target.getDataType()) {
            case 0: {
                return new Bytes(target);
            }
            case 2: {
                return new Shorts(target);
            }
            case 1: {
                return new UShorts(target);
            }
            case 3: {
                return new Integers(target);
            }
            case 4: {
                return new Floats(target);
            }
            case 5: {
                return new Doubles(target);
            }
        }
        return null;
    }

    private int prepare(Point location, RenderedImage[] sources) {
        int tileWidth = this.target.getWidth();
        int tileHeight = this.target.getHeight();
        int scanlineStride = this.target.getScanlineStride();
        int size = scanlineStride * tileHeight;
        int band = 0;
        boolean sharing = false;
        this.parents = new Raster[sources.length];
        this.sourceTileIndices = new int[sources.length * 2];
        for (int si = 0; si < sources.length; ++si) {
            int tileY;
            int tileX;
            RenderedImage source = sources[si];
            if (source.getTileWidth() == tileWidth && source.getTileHeight() == tileHeight && ((tileX = Math.subtractExact(location.x, source.getTileGridXOffset())) % tileWidth | (tileY = Math.subtractExact(location.y, source.getTileGridYOffset())) % tileHeight) == 0) {
                ComponentSampleModel sm;
                int n = si << 1;
                this.sourceTileIndices[n] = tileX /= tileWidth;
                this.sourceTileIndices[n + 1] = tileY /= tileHeight;
                Raster raster = source.getTile(tileX, tileY);
                SampleModel c = raster.getSampleModel();
                if (c instanceof ComponentSampleModel && (sm = (ComponentSampleModel)c).getPixelStride() == 1 && sm.getScanlineStride() == scanlineStride) {
                    DataBuffer buffer = raster.getDataBuffer();
                    int[] offsets1 = buffer.getOffsets();
                    int[] offsets2 = sm.getBandOffsets();
                    int[] indices = sm.getBankIndices();
                    for (int i = 0; i < indices.length; ++i) {
                        int b = indices[i];
                        this.takeReference(buffer, b, band);
                        this.offsets[band] = offsets1[b] + offsets2[i];
                        ++band;
                    }
                    size = Math.max(size, buffer.getSize());
                    this.parents[si] = raster;
                    sharing = true;
                    continue;
                }
            }
            band += ImageUtilities.getNumBands(source);
        }
        if (band != this.offsets.length) {
            throw new AssertionError();
        }
        return sharing ? size : 0;
    }

    final BandSharedRaster createRaster(Point location, RenderedImage[] sources) {
        int size = this.prepare(location, sources);
        if (size == 0) {
            return null;
        }
        DataBuffer buffer = this.allocate(size);
        return new BandSharedRaster(this.sourceTileIndices, this.parents, this.target, buffer, location);
    }

    abstract void takeReference(DataBuffer var1, int var2, int var3);

    abstract DataBuffer allocate(int var1);

    private static final class Bytes
    extends BandSharing {
        private final byte[][] data;

        Bytes(BandedSampleModel target) {
            super(target);
            this.data = new byte[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferByte)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new byte[size];
            }
            return new DataBufferByte(this.data, size, this.offsets);
        }
    }

    private static final class Shorts
    extends BandSharing {
        private final short[][] data;

        Shorts(BandedSampleModel target) {
            super(target);
            this.data = new short[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferShort)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new short[size];
            }
            return new DataBufferShort(this.data, size, this.offsets);
        }
    }

    private static final class UShorts
    extends BandSharing {
        private final short[][] data;

        UShorts(BandedSampleModel target) {
            super(target);
            this.data = new short[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferUShort)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new short[size];
            }
            return new DataBufferUShort(this.data, size, this.offsets);
        }
    }

    private static final class Integers
    extends BandSharing {
        private final int[][] data;

        Integers(BandedSampleModel target) {
            super(target);
            this.data = new int[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferInt)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new int[size];
            }
            return new DataBufferInt(this.data, size, this.offsets);
        }
    }

    private static final class Floats
    extends BandSharing {
        private final float[][] data;

        Floats(BandedSampleModel target) {
            super(target);
            this.data = new float[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferFloat)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new float[size];
            }
            return new DataBufferFloat(this.data, size, this.offsets);
        }
    }

    private static final class Doubles
    extends BandSharing {
        private final double[][] data;

        Doubles(BandedSampleModel target) {
            super(target);
            this.data = new double[this.offsets.length][];
        }

        @Override
        void takeReference(DataBuffer buffer, int src, int dst) {
            this.data[dst] = ((DataBufferDouble)buffer).getData(src);
        }

        @Override
        DataBuffer allocate(int size) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] != null) continue;
                this.data[i] = new double[size];
            }
            return new DataBufferDouble(this.data, size, this.offsets);
        }
    }
}

