/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Set;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.DefaultFilterFactory;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.Node;
import org.apache.sis.math.FunctionProperty;
import org.opengis.feature.FeatureType;
import org.opengis.filter.Expression;
import org.opengis.filter.Literal;
import org.opengis.filter.ValueReference;

public interface FeatureExpression<R, V>
extends Expression<R, V> {
    default public Set<FunctionProperty> properties() {
        return Node.transitiveProperties(this.getParameters());
    }

    default public Class<?> getValueClass() {
        return Object.class;
    }

    public PropertyTypeBuilder expectedType(FeatureType var1, FeatureTypeBuilder var2);

    public static FeatureExpression<?, ?> castOrCopy(Expression<?, ?> candidate) {
        ValueReference copy;
        if (candidate instanceof FeatureExpression) {
            return (FeatureExpression)candidate;
        }
        if (candidate instanceof Literal) {
            copy = Optimization.literal(((Literal)candidate).getValue());
        } else if (candidate instanceof ValueReference) {
            String xpath = ((ValueReference)candidate).getXPath();
            copy = DefaultFilterFactory.forFeatures().property(xpath);
        } else {
            return null;
        }
        return (FeatureExpression)copy;
    }
}

