/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.dgiwg.testsuite.dataprovider;

import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.domain.WfsNamespaces;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class WfsDataProvider {
    private static final NamespaceBindings NS_BINDINGS = WfsNamespaces.withStandardBindings();

    private WfsDataProvider() {
    }

    public static Object[][] provideFeatureTypeNodes(ProtocolBinding protocolBinding, Document wfsCapabilities) throws XPathExpressionException {
        String xPathMainNodeToParse = "//wfs:FeatureType";
        String xPathSubElementToParse = "wfs:Name";
        return WfsDataProvider.parseNode(protocolBinding, wfsCapabilities, xPathMainNodeToParse, xPathSubElementToParse);
    }

    public static Object[][] provideStoredQueryDescriptionNodes(ProtocolBinding protocolBinding, Document describeStoredQueryResponse) throws XPathExpressionException {
        String xPathMainNodeToParse = "//wfs:StoredQueryDescription";
        String xPathSubElementToParse = "@id";
        return WfsDataProvider.parseNode(protocolBinding, describeStoredQueryResponse, xPathMainNodeToParse, xPathSubElementToParse);
    }

    private static Object[][] parseNode(ProtocolBinding protocolBinding, Document doc, String xPathMainNodeToParse, String xPathSubElementToParse) throws XPathExpressionException {
        XPath xPath = WfsDataProvider.createXPath();
        NodeList mainNodes = (NodeList)xPath.evaluate(xPathMainNodeToParse, doc, XPathConstants.NODESET);
        Object[][] resultNodesAndKeys = new Object[mainNodes.getLength()][];
        for (int mainNodeIndex = 0; mainNodeIndex < mainNodes.getLength(); ++mainNodeIndex) {
            Node mainNode = mainNodes.item(mainNodeIndex);
            String key = (String)xPath.evaluate(xPathSubElementToParse, mainNode, XPathConstants.STRING);
            resultNodesAndKeys[mainNodeIndex] = new Object[]{protocolBinding, mainNode, key};
        }
        return resultNodesAndKeys;
    }

    private static XPath createXPath() {
        try {
            XPathFactory factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext((NamespaceContext)NS_BINDINGS);
            return xpath;
        }
        catch (XPathFactoryConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

