/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.dgiwg.testsuite.getcapabilities;

import de.latlon.ets.core.keyword.DfddKeywordMatcher;
import de.latlon.ets.core.keyword.DfddKeywordMatcherFromFile;
import de.latlon.ets.wfs20.core.dgiwg.testsuite.WfsBaseFixture;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesKeywordTest
extends WfsBaseFixture {
    private static final DfddKeywordMatcher DFDD_KEYWORD_MATCHER = new DfddKeywordMatcherFromFile();

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.2.1., S.18, Requirement 3")
    public void wfsCapabilitiesContainsKeywordFromDFDDRegister() throws XPathFactoryConfigurationException, XPathExpressionException {
        List<String> keywords = this.parseKeywords(this.wfsMetadata);
        boolean atLeastOneKeywordIsFromDfdd = DFDD_KEYWORD_MATCHER.containsAtLeastOneDfddKeyword(keywords);
        Assert.assertTrue((boolean)atLeastOneKeywordIsFromDfdd, (String)("Invalid keywords, expected is at least one keyword from DFDD, but is " + keywords));
    }

    private List<String> parseKeywords(Document wmsCapabilities) throws XPathFactoryConfigurationException, XPathExpressionException {
        String xPathExpr = "//wfs:WFS_Capabilities/ows:ServiceIdentification/ows:Keywords/ows:Keyword";
        NodeList keywordNodes = (NodeList)this.createXPath().evaluate(xPathExpr, wmsCapabilities, XPathConstants.NODESET);
        ArrayList<String> keywords = new ArrayList<String>();
        for (int keywordNodeIndex = 0; keywordNodeIndex < keywordNodes.getLength(); ++keywordNodeIndex) {
            Node keywordNode = keywordNodes.item(keywordNodeIndex);
            String keyword = keywordNode.getTextContent();
            if (keyword == null) continue;
            keywords.add(keyword.trim());
        }
        return keywords;
    }
}

