/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.spatialfilter;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.utils.ValidationUtils;
import de.latlon.ets.wfs20.core.wfs20.testsuite.spatialfilter.AbstractSpatialFilterTest;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.geometry.Envelope;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtendedSpatialFilterTest
extends AbstractSpatialFilterTest {
    @BeforeClass
    public void init(ITestContext testContext) {
        this.gmlGeomBaseType = this.model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
        this.wfsSchema = ValidationUtils.createWFSSchema(this.wfsMetadata);
    }

    @DataProvider(name="spatialOperator")
    public Iterator<Object[]> spatialOperators() throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String spatialOperator : EXPECTED_SPATIAL_OPERATORS) {
            params.add(new Object[]{ProtocolBinding.POST, spatialOperator});
        }
        return params.iterator();
    }

    @DataProvider(name="protocol-featureType-allSpatialOperator")
    public Iterator<Object[]> protocolsAndFeatureTypesAndSpatialOperators() throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Set operationBindings = ServiceMetadataUtils.getOperationBindings((Document)this.wfsMetadata, (String)"GetFeature");
        for (ProtocolBinding binding : operationBindings) {
            for (QName typeName : this.featureTypes) {
                for (String spatialOperator : EXPECTED_SPATIAL_OPERATORS) {
                    params.add(new Object[]{binding, typeName, spatialOperator});
                }
            }
        }
        return params.iterator();
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 9", dataProvider="spatialOperator")
    public void spatialOperatorIsEnabled(ProtocolBinding binding, String spatialOperator) {
        String xPathXml = String.format("//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Spatial_Capabilities/fes:SpatialOperators/fes:SpatialOperator[@name='%s']", spatialOperator);
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 9", dataProvider="protocol-featureType-allSpatialOperator")
    public void spatialOperatorFilterIsSupported(ProtocolBinding binding, QName featureType, String spatialOperatorName) {
        XSElementDeclaration geomProp = this.findGeometryProperty(featureType);
        Element valueRef = WFSMessage.createValueReference((XSElementDeclaration)geomProp);
        WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureType});
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getSpatialExtent());
        this.addSpatialOperatorPredicate(this.reqEntity, spatialOperatorName, gmlEnv.getDocumentElement(), valueRef);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertSchemaValid((Schema)this.wfsSchema, (Document)this.rspEntity);
    }
}

