/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.ets.wfs20.core.wfs20.testsuite.spatialfilter;

import de.latlon.ets.core.assertion.ETSAssert;
import de.latlon.ets.core.util.NamespaceBindings;
import de.latlon.ets.wfs20.core.utils.ValidationUtils;
import de.latlon.ets.wfs20.core.wfs20.testsuite.spatialfilter.AbstractSpatialFilterTest;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.geometry.Envelope;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpatialFilterTest
extends AbstractSpatialFilterTest {
    @BeforeClass
    public void init(ITestContext testContext) {
        this.gmlGeomBaseType = this.model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
        this.wfsSchema = ValidationUtils.createWFSSchema(this.wfsMetadata);
    }

    @DataProvider(name="protocol-featureType-spatialOperator")
    public Iterator<Object[]> protocolsAndFeatureTypesAndSpatialOperators() throws XPathFactoryConfigurationException, XPathExpressionException {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Set operationBindings = ServiceMetadataUtils.getOperationBindings((Document)this.wfsMetadata, (String)"GetFeature");
        for (ProtocolBinding binding : operationBindings) {
            for (QName typeName : this.featureTypes) {
                for (String spatialOperator : this.parseExpectedSpatialOperators(this.wfsMetadata)) {
                    params.add(new Object[]{binding, typeName, spatialOperator});
                }
            }
        }
        return params.iterator();
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 8; OGC 09-026R2 Spatial Filter CC, A.8")
    public void inCapabilitiesImplementsSpatialFilterIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Conformance/fes:Constraint[@name='ImplementsSpatialFilter']/ows:DefaultValue = 'TRUE'";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 8; OGC 09-026R2 Spatial Filter CC, A.8")
    public void inCapabilitiesBBOXOperatorIsEnabled() {
        String xPathXml = "//wfs:WFS_Capabilities/fes:Filter_Capabilities/fes:Spatial_Capabilities/fes:SpatialOperators/fes:SpatialOperator[@name='BBOX']";
        ETSAssert.assertXPath((String)xPathXml, (Node)this.wfsMetadata, (NamespaceBindings)NS_BINDINGS);
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 8; OGC 09-026R2 Spatial Filter CC, A.8")
    public void inCapabilitiesOneMoreSpatialOperatorIsEnabled() throws XPathFactoryConfigurationException, XPathExpressionException {
        List<String> supportedSpatialOperators = this.parseExpectedSpatialOperators(this.wfsMetadata);
        Assert.assertTrue((supportedSpatialOperators.size() > 0 ? 1 : 0) != 0, (String)("SpatialOperators are not valid. At least one of the spatial operators " + EXPECTED_SPATIAL_OPERATORS + " is expected"));
    }

    @Test(description="DGIWG - Web Feature Service 2.0 Profile, 7.3.2., S.24, Requirement 8; OGC 09-026R2 Spatial Filter CC, A.8", dataProvider="protocol-featureType-spatialOperator")
    public void withSpatialOperatorFilter(ProtocolBinding binding, QName featureType, String spatialOperatorName) {
        XSElementDeclaration geomProp = this.findGeometryProperty(featureType);
        Element valueRef = WFSMessage.createValueReference((XSElementDeclaration)geomProp);
        WFSMessage.appendSimpleQuery((Document)this.reqEntity, (QName[])new QName[]{featureType});
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getSpatialExtent());
        this.addSpatialOperatorPredicate(this.reqEntity, spatialOperatorName, gmlEnv.getDocumentElement(), valueRef);
        Response rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)Response.Status.OK.getStatusCode(), (String)ErrorMessage.get((String)"UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        ETSAssert.assertSchemaValid((Schema)this.wfsSchema, (Document)this.rspEntity);
    }
}

