/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.locking;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.locking.LockingFixture;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LockFeatureTests
extends LockingFixture {
    private static Random randomIndex = new Random(System.currentTimeMillis());

    @BeforeMethod
    public void buildSimpleLockFeatureRequest() {
        this.reqEntity = WFSRequest.createRequestEntity("LockFeature");
    }

    @Test(description="See ISO 19142: 12.2.4.2")
    public void resetNonexistentLock() {
        Map<String, QName> featureId = this.fetchRandomFeatureIdentifier(this.featureInfo);
        String gmlId = featureId.keySet().iterator().next();
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureById", Collections.singletonMap("id", gmlId));
        this.reqEntity.getDocumentElement().setAttribute("lockId", "lock-does-not-exist");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.FORBIDDEN.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'LockHasExpired']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 12.2.4.3, 15.2.3.1.2")
    public void lockFeatureAndAttemptDelete() {
        Map<String, QName> featureId = this.fetchRandomFeatureIdentifier(this.featureInfo);
        String gmlId = featureId.keySet().iterator().next();
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureById", Collections.singletonMap("id", gmlId));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "60");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertXPath("//wfs:LockFeatureResponse", this.rspEntity, null);
        Element lockRsp = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "LockFeatureResponse").item(0);
        String lockId = lockRsp.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId"));
        this.locks.add(lockId);
        String xpath = String.format("//wfs:FeaturesLocked/fes:ResourceId/@rid = '%s'", gmlId);
        ETSAssert.assertXPath(xpath, lockRsp, null);
        Document trxResponse = this.wfsClient.delete(featureId, ProtocolBinding.ANY);
        String xpath2 = "//ows:Exception[@exceptionCode = 'MissingParameterValue']";
        ETSAssert.assertXPath(xpath2, trxResponse.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 12.2.3, 12.2.5")
    public void lockFeatureAlreadyLocked() {
        Map<String, QName> featureId = this.fetchRandomFeatureIdentifier(this.featureInfo);
        String gmlId = featureId.keySet().iterator().next();
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureById", Collections.singletonMap("id", gmlId));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "60");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element lockRsp = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "LockFeatureResponse").item(0);
        this.locks.add(lockRsp.getAttribute("lockId"));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "180");
        rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'CannotLockAllFeatures']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 12.3.2", dataProvider="protocol-featureType")
    public void lockAllFeaturesByType(ProtocolBinding binding, QName featureType) {
        if (!((FeatureTypeInfo)this.featureInfo.get(featureType)).isInstantiated()) {
            throw new SkipException("No data available for feature type " + featureType);
        }
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "LockFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element lockRsp = this.rspEntity.getDocumentElement();
        Assert.assertEquals((String)lockRsp.getLocalName(), (String)"LockFeatureResponse", (String)ErrorMessage.get("LocalName"));
        String lockId = lockRsp.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId in " + lockRsp.getNodeName()));
        this.locks.add(lockId);
        ETSAssert.assertXPath("//wfs:FeaturesLocked", lockRsp, null);
        ETSAssert.assertXPath("not(//wfs:FeaturesNotLocked)", lockRsp, null);
    }

    Map<String, QName> fetchRandomFeatureIdentifier(Map<QName, FeatureTypeInfo> featureInfo) {
        HashMap<String, QName> featureId = new HashMap<String, QName>();
        QName featureType = LockFeatureTests.selectRandomFeatureType(featureInfo);
        if (null != featureType) {
            Document doc = this.wfsClient.getFeatureByType(featureType, 10, null);
            NodeList features = doc.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
            Element feature = (Element)features.item(randomIndex.nextInt(features.getLength()));
            featureId.put(feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), featureType);
        }
        if (TestSuiteLogger.isLoggable(Level.FINER)) {
            TestSuiteLogger.log(Level.FINER, ((Object)featureId).toString());
        }
        return featureId;
    }

    static QName selectRandomFeatureType(Map<QName, FeatureTypeInfo> featureTypes) {
        ArrayList<FeatureTypeInfo> availableTypes = new ArrayList<FeatureTypeInfo>();
        for (FeatureTypeInfo typeInfo : featureTypes.values()) {
            if (!typeInfo.isInstantiated()) continue;
            availableTypes.add(typeInfo);
        }
        if (availableTypes.isEmpty()) {
            return null;
        }
        FeatureTypeInfo availableType = (FeatureTypeInfo)availableTypes.get(randomIndex.nextInt(availableTypes.size()));
        return availableType.getTypeName();
    }
}

