/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.spatial;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.TopologicalRelationships;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.TransformException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IntersectsTests
extends QueryFilterFixture {
    public static final String IMPL_SPATIAL_FILTER = "ImplementsSpatialFilter";
    private static final String INTERSECTS_OP = "Intersects";
    private XSTypeDefinition gmlGeomBaseType;
    private static final String XSLT_ENV2POLYGON = "/org/opengis/cite/iso19142/util/bbox2polygon.xsl";

    @BeforeTest
    public void implementsSpatialFilter(ITestContext testContext) {
        NodeList result;
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//fes:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]", IMPL_SPATIAL_FILTER);
        try {
            result = XMLUtils.evaluateXPath(this.wfsMetadata, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (result.getLength() == 0) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", IMPL_SPATIAL_FILTER));
        }
    }

    @BeforeClass
    public void createGeometryBaseType() {
        this.gmlGeomBaseType = this.model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2");
    }

    @BeforeClass
    public void implementsIntersectsOp() {
        if (!ServiceMetadataUtils.implementsSpatialOperator(this.wfsMetadata, INTERSECTS_OP)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", "Intersects operator"));
        }
    }

    @Test(description="See ISO 19143: 7.8.3.2", dataProvider="protocol-featureType")
    public void intersectsPolygon(ProtocolBinding binding, QName featureType) {
        List<XSElementDeclaration> geomProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, this.gmlGeomBaseType);
        if (geomProps.isEmpty()) {
            throw new SkipException("Feature type has no geometry properties: " + featureType);
        }
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Document gmlEnv = Extents.envelopeAsGML((Envelope)((FeatureTypeInfo)this.featureInfo.get(featureType)).getGeoExtent());
        Element gmlPolygon = XMLUtils.transform(new StreamSource(this.getClass().getResourceAsStream(XSLT_ENV2POLYGON)), gmlEnv).getDocumentElement();
        XSElementDeclaration geomProperty = geomProps.get(0);
        Element valueRef = WFSMessage.createValueReference(geomProperty);
        this.addSpatialPredicate(this.reqEntity, INTERSECTS_OP, gmlPolygon, valueRef);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        XSElementDeclaration geomValue = AppSchemaUtils.getComplexPropertyValue(geomProperty);
        XSElementDeclaration[] expectedValues = new XSElementDeclaration[1];
        if (geomValue.getAbstract()) {
            List allowedValues = XMLSchemaModelUtils.getElementsByAffiliation((XSModel)this.model, (XSElementDeclaration)geomValue);
            if (allowedValues.isEmpty()) {
                throw new AssertionError((Object)String.format("For property %s, no substitutable elements found for abstract property value: ", geomProperty, geomValue));
            }
            expectedValues = allowedValues.toArray(expectedValues);
        } else {
            expectedValues[0] = geomValue;
        }
        List<Node> geomNodes = WFSMessage.findMatchingElements(this.rspEntity, expectedValues);
        Assert.assertFalse((boolean)geomNodes.isEmpty(), (String)String.format("No geometry elements found in response: %s", geomValue));
        for (Node geom : geomNodes) {
            try {
                boolean intersects = TopologicalRelationships.intersects((Node)gmlPolygon, (Node)geom);
                Assert.assertTrue((boolean)intersects, (String)ErrorMessage.format("PredicateNotSatisfied", INTERSECTS_OP, XMLUtils.writeNodeToString(gmlPolygon), XMLUtils.writeNodeToString(geom)));
            }
            catch (TransformException te) {
                throw new RuntimeException(String.format("Attempted coordinate transformation failed for srsName=%s", GmlUtils.findCRSReference((Element)((Element)geom))), te);
            }
        }
    }

    void addSpatialPredicate(Document request, String spatialOp, Element gmlGeom, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        if (null == queryElem) {
            throw new IllegalArgumentException("No Query element found in GetFeature request entity.");
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + spatialOp);
        filter.appendChild(predicate);
        if (null != valueRef) {
            predicate.appendChild(request.importNode(valueRef, true));
        }
        predicate.appendChild(request.importNode(gmlGeom, true));
    }
}

