/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.temporal;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.TimeUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DuringTests
extends QueryFilterFixture {
    private static final String DURING_OP = "During";
    public static final String IMPL_TEMPORAL_FILTER = "ImplementsTemporalFilter";
    private XSTypeDefinition gmlTimeBaseType;

    @BeforeTest
    public void implementsTemporalFilter(ITestContext testContext) {
        NodeList result;
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//fes:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]", IMPL_TEMPORAL_FILTER);
        try {
            result = XMLUtils.evaluateXPath(this.wfsMetadata, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (result.getLength() == 0) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", IMPL_TEMPORAL_FILTER));
        }
    }

    @BeforeClass
    public void createTemporalPrimitiveBaseType() {
        this.gmlTimeBaseType = this.model.getTypeDefinition("AbstractTimeGeometricPrimitiveType", "http://www.opengis.net/gml/3.2");
    }

    @Test(description="See ISO 19143: 7.14.6, A.9", dataProvider="protocol-featureType")
    public void duringFixedPeriod(ProtocolBinding binding, QName featureType) {
        List<XSElementDeclaration> timeProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, this.gmlTimeBaseType);
        for (XSTypeDefinition dataType : AppSchemaUtils.getSimpleTemporalDataTypes(this.model)) {
            timeProps.addAll(AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, dataType));
        }
        TestSuiteLogger.log(Level.FINE, String.format("Temporal properties for feature type %s: %s", featureType, timeProps));
        if (timeProps.isEmpty()) {
            throw new SkipException("Feature type has no temporal properties: " + featureType);
        }
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        ZonedDateTime endTime = ZonedDateTime.now(ZoneId.of("Z"));
        ZonedDateTime startTime = endTime.minusYears(5L);
        Document gmlTimePeriod = TimeUtils.periodAsGML(startTime, endTime);
        XSElementDeclaration timeProperty = timeProps.get(0);
        Element valueRef = WFSMessage.createValueReference(timeProperty);
        this.addTemporalPredicate(this.reqEntity, DURING_OP, gmlTimePeriod, valueRef);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
    }

    void addTemporalPredicate(Document request, String temporalOp, Document gmlTime, Element valueRef) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        if (null == queryElem) {
            throw new IllegalArgumentException("No Query element found in GetFeature request entity.");
        }
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "fes:" + temporalOp);
        filter.appendChild(predicate);
        if (null != valueRef) {
            predicate.appendChild(request.importNode(valueRef, true));
        }
        predicate.appendChild(request.importNode(gmlTime.getDocumentElement(), true));
    }
}

