/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.xml.sax.ErrorHandler;

public class ListStoredQueriesTests
extends BaseFixture {
    private Schema wfsSchema;

    @BeforeClass
    public void setupClassFixture(ITestContext testContext) {
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull((Object)this.wfsSchema, (String)"WFS schema not found in suite fixture.");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.reqEntity = builder.parse(this.getClass().getResourceAsStream("ListStoredQueries.xml"));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse request entity from classpath", e);
        }
    }

    @Test(description="See ISO 19142: 14.3.4", dataProvider="protocol-binding")
    public void listStoredQueries(ProtocolBinding binding) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "ListStoredQueries", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Validator validator = this.wfsSchema.newValidator();
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(new DOMSource(this.rspEntity, this.rspEntity.getDocumentURI()));
        }
        catch (Exception ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to validate WFS capabilities document", ex);
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
        String xpath = String.format("//wfs:StoredQuery[@id='%s' or @id='%s']", "http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById", "urn:ogc:def:query:OGC-WFS::GetFeatureById");
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }
}

