/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransactionCapabilitiesTests
extends BaseFixture {
    static final String TRX_WFS_PHASE = "TransactionalWFSPhase";
    static final String SCHEMATRON_METADATA = "wfs-capabilities-2.0.sch";

    @BeforeTest
    public void checkSuitePreconditions(ITestContext context) {
        Object failedPreconditions = context.getSuite().getAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName());
        if (null != failedPreconditions) {
            throw new SkipException("One or more test suite preconditions were not satisfied: " + failedPreconditions);
        }
    }

    @BeforeTest
    public void implementsTransactionalWFS(ITestContext testContext) {
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//ows:Constraint[@name='%s']/ows:DefaultValue = 'TRUE'", "ImplementsTransactionalWFS");
        ETSAssert.assertXPath(xpath, this.wfsMetadata, null);
    }

    @BeforeClass
    public void buildGetCapabilitiesRequest() {
        this.reqEntity = this.docBuilder.newDocument();
        Element docElem = this.reqEntity.createElementNS("http://www.opengis.net/wfs/2.0", "GetCapabilities");
        docElem.setAttribute("service", "WFS");
        this.reqEntity.appendChild(docElem);
    }

    @Test(description="See ISO 19142: Table 13, A.2.23")
    public void capabilitiesDescribesTransactionalWFS() {
        SchematronValidator validator = ValidationUtils.buildSchematronValidator(SCHEMATRON_METADATA, TRX_WFS_PHASE);
        DOMResult result = validator.validate((Source)new DOMSource(this.wfsMetadata, this.wfsMetadata.getDocumentURI()));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }
}

