/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TimeUtils {
    private static final DocumentBuilder DOC_BUILDER = TimeUtils.initDocBuilder();

    private static DocumentBuilder initDocBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "TimeUtils: Failed to create DocumentBuilder", e);
        }
        return builder;
    }

    public static Document periodAsGML(ZonedDateTime startTime, ZonedDateTime endTime) {
        Document gmlTimePeriod;
        try {
            gmlTimePeriod = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimePeriod.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        String beginPosition = startTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "beginPosition").item(0).setTextContent(beginPosition);
        String endPosition = endTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "endPosition").item(0).setTextContent(endPosition);
        return gmlTimePeriod;
    }
}

