/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.WFSClient;
import org.testng.Assert;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SuitePreconditions {
    private static final Logger LOGR = Logger.getLogger(SuitePreconditions.class.getName());

    @AfterMethod
    public void preconditionNotSatisfied(ITestResult result) {
        if (!result.isSuccess()) {
            ArrayList failedPreconditions = result.getTestContext().getSuite().getAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName());
            if (null == failedPreconditions) {
                failedPreconditions = new ArrayList();
                result.getTestContext().getSuite().setAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName(), failedPreconditions);
            }
            ((ArrayList)ArrayList.class.cast(failedPreconditions)).add(result.getName());
        }
    }

    @Test(description="Test subject is WFS 2.0 service")
    public void verifyServiceDescription(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        ETSAssert.assertQualifiedName(wfsMetadata.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "WFS_Capabilities"));
    }

    @Test(description="SUT produces GetCapabilities response", dependsOnMethods={"verifyServiceDescription"})
    public void serviceIsAvailable(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        WFSClient wfsClient = new WFSClient(wfsMetadata);
        Document capabilities = wfsClient.getCapabilities();
        Assert.assertNotNull((Object)capabilities, (String)"No GetCapabilities response from SUT.");
        Element docElement = capabilities.getDocumentElement();
        Assert.assertEquals((String)docElement.getLocalName(), (String)"WFS_Capabilities", (String)"Capabilities document element has unexpected [local name].");
        Assert.assertEquals((String)docElement.getNamespaceURI(), (String)"http://www.opengis.net/wfs/2.0", (String)"Capabilities document element has unexpected [namespace name].");
    }

    @Test(description="SUT has data for at least one advertised feature type", dependsOnMethods={"verifyServiceDescription"})
    public void dataAreAvailable(ITestContext testContext) {
        ISuite suite = testContext.getSuite();
        Document wfsMetadata = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        DataSampler sampler = new DataSampler(wfsMetadata);
        try {
            sampler.acquireFeatureData();
        }
        catch (RuntimeException rx) {
            throw new AssertionError((Object)rx.getMessage());
        }
        Map<QName, FeatureTypeInfo> featureTypeInfo = sampler.getFeatureTypeInfo();
        boolean sutHasData = false;
        for (FeatureTypeInfo typeInfo : featureTypeInfo.values()) {
            if (!typeInfo.isInstantiated()) continue;
            sutHasData = true;
            break;
        }
        if (!sutHasData) {
            String msg = ErrorMessage.get("DataNotAvailable");
            LOGR.warning(msg + featureTypeInfo.toString());
            throw new AssertionError((Object)msg);
        }
        suite.setAttribute(SuiteAttribute.FEATURE_INFO.getName(), featureTypeInfo);
        suite.setAttribute(SuiteAttribute.SAMPLER.getName(), (Object)sampler);
    }
}

