/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.time.TemporalComparator;
import org.opengis.cite.geomatics.time.TemporalUtils;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.temporal.TemporalQuery;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.NamespaceBindings;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSClient;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DataSampler {
    private static final Logger LOGR = Logger.getLogger(DataSampler.class.getPackage().getName());
    private int maxFeatures = 25;
    private Document serviceDescription;
    private Map<QName, FeatureTypeInfo> featureInfo;

    public DataSampler(Document wfsCapabilities) {
        if (null == wfsCapabilities || !wfsCapabilities.getDocumentElement().getLocalName().equals("WFS_Capabilities")) {
            throw new IllegalArgumentException("Did not supply a WFS capabilities document");
        }
        this.serviceDescription = wfsCapabilities;
        this.featureInfo = ServiceMetadataUtils.extractFeatureInfo(wfsCapabilities);
    }

    public void setMaxFeatures(int maxFeatures) {
        if (maxFeatures > 0) {
            this.maxFeatures = maxFeatures;
        }
    }

    public Set<String> selectRandomFeatureIdentifiers(QName featureType, int numId) {
        FeatureTypeInfo typeInfo = this.featureInfo.get(featureType);
        File dataFile = typeInfo.getSampleData();
        HashSet<String> idSet = new HashSet<String>();
        if (null == dataFile || !dataFile.exists()) {
            return idSet;
        }
        String xpath = "//wfs:member/*/@gml:id";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        XdmValue result = null;
        try {
            result = XMLUtils.evaluateXPath2(new StreamSource(dataFile), xpath, nsBindings);
        }
        catch (SaxonApiException e) {
            LOGR.log(Level.WARNING, String.format("Failed to extract feature identifiers from data file at %s", dataFile.getAbsolutePath()));
        }
        int sampleSize = result.size();
        numId = numId > sampleSize ? sampleSize : numId;
        Random random = new Random();
        while (idSet.size() < numId) {
            int randomInt = random.nextInt(sampleSize);
            idSet.add(result.itemAt(randomInt).getStringValue());
        }
        return idSet;
    }

    public List<String> getSimplePropertyValues(QName featureType, QName propName, String featureId) {
        FeatureTypeInfo typeInfo = this.featureInfo.get(featureType);
        File dataFile = typeInfo.getSampleData();
        ArrayList<String> values = new ArrayList<String>();
        if (null == dataFile || !dataFile.exists()) {
            return values;
        }
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
        nsBindings.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        nsBindings.put(featureType.getNamespaceURI(), "ns1");
        StringBuilder xpath = new StringBuilder("//wfs:member/ns1:");
        xpath.append(featureType.getLocalPart());
        if (null != featureId && !featureId.isEmpty()) {
            xpath.append("[@gml:id='").append(featureId).append("']");
        }
        if (!propName.getNamespaceURI().equals(featureType.getNamespaceURI())) {
            xpath.append("/ns2:");
            nsBindings.put(propName.getNamespaceURI(), "ns2");
        } else {
            xpath.append("/ns1:");
        }
        xpath.append(propName.getLocalPart());
        xpath.append("[not(@xsi:nil)]");
        XdmValue result = null;
        try {
            result = XMLUtils.evaluateXPath2(new StreamSource(dataFile), xpath.toString(), nsBindings);
        }
        catch (SaxonApiException e) {
            LOGR.log(Level.WARNING, String.format("Failed to evaluate XPath expression %s against data at %s\n%s\n", xpath, dataFile.getAbsolutePath(), nsBindings) + e.getMessage());
        }
        if (null != result) {
            for (XdmItem item : result) {
                values.add(item.getStringValue());
            }
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.log(Level.FINE, "[{0}] Evaluating xpath {1}\n {2}", new Object[]{this.getClass().getName(), xpath, values});
        }
        return values;
    }

    public boolean deleteData() {
        boolean allDeleted = true;
        for (QName typeName : this.featureInfo.keySet()) {
            File file = this.featureInfo.get(typeName).getSampleData();
            if (file == null || !file.exists() || file.delete()) continue;
            allDeleted = false;
            LOGR.log(Level.WARNING, "Failed to delete sample data file at " + file);
        }
        return allDeleted;
    }

    public void acquireFeatureData() {
        WFSClient wfsClient = new WFSClient(this.serviceDescription);
        Set<ProtocolBinding> getFeatureBindings = ServiceMetadataUtils.getOperationBindings(this.serviceDescription, "GetFeature");
        block4: for (Map.Entry<QName, FeatureTypeInfo> entry : this.featureInfo.entrySet()) {
            QName typeName = entry.getKey();
            for (ProtocolBinding binding : getFeatureBindings) {
                try {
                    Document rspEntity = wfsClient.getFeatureByType(typeName, this.maxFeatures, binding);
                    NodeList features = rspEntity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart());
                    boolean hasFeatures = features.getLength() > 0;
                    entry.getValue().setInstantiated(hasFeatures);
                    if (!hasFeatures) continue;
                    try {
                        File file = File.createTempFile(typeName.getLocalPart() + "-", ".xml");
                        FileOutputStream fos = new FileOutputStream(file);
                        XMLUtils.writeNode(rspEntity, fos);
                        LOGR.log(Level.FINE, this.getClass().getName() + " - wrote response entity to " + file.getAbsolutePath());
                        entry.getValue().setSampleData(file);
                        fos.close();
                    }
                    catch (IOException iox) {
                        LOGR.log(Level.WARNING, "Failed to save feature data.", iox);
                    }
                    continue block4;
                }
                catch (RuntimeException re) {
                    StringBuilder err = new StringBuilder();
                    err.append(String.format("Failed to read XML response entity using %s method for feature type %s.", new Object[]{binding, typeName}));
                    err.append(" \n").append(re.getMessage());
                    LOGR.log(Level.WARNING, err.toString(), re);
                    throw new RuntimeException(err.toString(), re);
                }
            }
        }
        LOGR.log(Level.INFO, this.featureInfo.toString());
    }

    public Map<QName, FeatureTypeInfo> getFeatureTypeInfo() {
        return this.featureInfo;
    }

    public Element getFeatureById(String id) {
        Element feature = null;
        for (FeatureTypeInfo featureInfo : this.featureInfo.values()) {
            if (!featureInfo.isInstantiated()) continue;
            File dataFile = featureInfo.getSampleData();
            String xpath = "//wfs:member/*[@gml:id='" + id + "']";
            HashMap<String, String> nsBindings = new HashMap<String, String>();
            nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
            nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
            XdmValue result = null;
            try {
                result = XMLUtils.evaluateXPath2(new StreamSource(dataFile), xpath, nsBindings);
            }
            catch (SaxonApiException e) {
                LOGR.log(Level.WARNING, String.format("Failed to evaluate XPath %s against data file at %s", xpath, dataFile.getAbsolutePath()));
            }
            if (null == result || result.size() <= 0) continue;
            XdmNode node = (XdmNode)result.itemAt(0);
            feature = (Element)ElementOverNodeInfo.wrap((NodeInfo)node.getUnderlyingNode());
            break;
        }
        return feature;
    }

    public String getFeatureId(QName featureType, boolean matchFeatureType) {
        String featureId = null;
        for (Map.Entry<QName, FeatureTypeInfo> entry : this.featureInfo.entrySet()) {
            QName typeName = entry.getKey();
            if (typeName.equals(featureType) != matchFeatureType || !entry.getValue().isInstantiated()) continue;
            File dataFile = entry.getValue().getSampleData();
            String expr = "(//wfs:member/*/@gml:id)[1]";
            HashMap<String, String> nsBindings = new HashMap<String, String>();
            nsBindings.put("http://www.opengis.net/gml/3.2", "gml");
            nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
            try {
                XdmValue result = XMLUtils.evaluateXPath2(new StreamSource(dataFile), expr, nsBindings);
                featureId = result.itemAt(0).getStringValue();
            }
            catch (SaxonApiException e) {
                LOGR.log(Level.WARNING, String.format("Failed to evaluate XPath %s against data file at %s", expr, dataFile.getAbsolutePath()));
            }
            break;
        }
        return featureId;
    }

    public Envelope getSpatialExtent(XSModel model, QName featureType) {
        List<XSElementDeclaration> geomProps = AppSchemaUtils.getFeaturePropertiesByType(model, featureType, model.getTypeDefinition("AbstractGeometryType", "http://www.opengis.net/gml/3.2"));
        if (geomProps.isEmpty()) {
            return null;
        }
        Iterator<XSElementDeclaration> itr = geomProps.iterator();
        NamespaceBindings nsBindings = NamespaceBindings.withStandardBindings();
        XPathFactory factory = XPathFactory.newInstance();
        NodeList geomNodes = null;
        File dataFile = this.featureInfo.get(featureType).getSampleData();
        do {
            XSElementDeclaration geomProp = itr.next();
            nsBindings.addNamespaceBinding(geomProp.getNamespace(), "ns1");
            String expr = String.format("//ns1:%s/*[1]", geomProp.getName());
            XPath xpath = factory.newXPath();
            xpath.setNamespaceContext(nsBindings);
            try {
                geomNodes = (NodeList)xpath.evaluate(expr, new InputSource(new FileInputStream(dataFile)), XPathConstants.NODESET);
            }
            catch (FileNotFoundException | XPathExpressionException e) {
                LOGR.log(Level.WARNING, String.format("Failed to evaluate XPath %s against data file at %s.\n %s", expr, dataFile.getAbsolutePath(), e.getMessage()));
            }
        } while ((null == geomNodes || geomNodes.getLength() <= 0) && itr.hasNext());
        Envelope extent = null;
        if (null != geomNodes && geomNodes.getLength() > 0) {
            try {
                extent = Extents.calculateEnvelope((NodeList)geomNodes);
            }
            catch (JAXBException e) {
                LOGR.log(Level.WARNING, String.format("Failed to create envelope from geometry nodes.", e.getMessage()));
            }
        }
        return extent;
    }

    public Period getTemporalExtent(XSModel model, QName featureType, XSElementDeclaration tmProp) {
        Document data;
        QName propertyName = new QName(tmProp.getNamespace(), tmProp.getName());
        Period period = this.featureInfo.get(featureType).getTemporalExtent(propertyName);
        if (null != period) {
            return period;
        }
        File dataFile = this.featureInfo.get(featureType).getSampleData();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            data = factory.newDocumentBuilder().parse(dataFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(String.format("Failed to parse data file at %s.\n %s", dataFile.getAbsolutePath(), e.getMessage()));
        }
        TreeSet<TemporalGeometricPrimitive> tmSet = new TreeSet<TemporalGeometricPrimitive>((Comparator<TemporalGeometricPrimitive>)new TemporalComparator());
        NodeList propNodes = data.getElementsByTagNameNS(tmProp.getNamespace(), tmProp.getName());
        for (int i = 0; i < propNodes.getLength(); ++i) {
            XSTypeDefinition propType = tmProp.getTypeDefinition();
            Node prop = propNodes.item(i);
            try {
                TemporalGeometricPrimitive tVal = propType.getTypeCategory() == 16 ? TemporalQuery.parseTemporalValue(prop.getTextContent(), propType) : GmlUtils.gmlToTemporalGeometricPrimitive((Element)((Element)prop.getFirstChild()));
                tmSet.add(tVal);
                continue;
            }
            catch (RuntimeException re) {
                LOGR.log(Level.WARNING, re.getMessage());
            }
        }
        period = TemporalUtils.temporalExtent(tmSet);
        this.featureInfo.get(featureType).setTemporalExtent(propertyName, period);
        return period;
    }
}

