/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;

public class FeatureProperty {
    private QName name;
    private QName featureType;
    private QName valueType;
    private XSElementDeclaration declaration;

    public FeatureProperty() {
    }

    public FeatureProperty(QName featureType, XSElementDeclaration declaration) {
        this.featureType = featureType;
        this.declaration = declaration;
        this.setName(new QName(declaration.getNamespace(), declaration.getName()));
        this.setValueType(this.getTypeName(declaration));
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public QName getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(QName featureType) {
        this.featureType = featureType;
    }

    public QName getValueType() {
        return this.valueType;
    }

    public void setValueType(QName valueType) {
        this.valueType = valueType;
    }

    public XSElementDeclaration getDeclaration() {
        return this.declaration;
    }

    public void setDeclaration(XSElementDeclaration declaration) {
        this.declaration = declaration;
        this.setName(new QName(declaration.getNamespace(), declaration.getName()));
        this.setValueType(this.getTypeName(declaration));
    }

    QName getTypeName(XSElementDeclaration decl) {
        XSTypeDefinition typeDef = decl.getTypeDefinition();
        QName typeName = null;
        if (typeDef.getTypeCategory() == 16) {
            typeName = new QName(typeDef.getNamespace(), typeDef.getName());
        } else {
            XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)typeDef;
            XSElementDeclaration elemDecl = (XSElementDeclaration)XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)complexTypeDef.getParticle()).get(0);
            typeName = new QName(elemDecl.getNamespace(), elemDecl.getName());
        }
        return typeName;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getFeatureType()).append('/');
        str.append(this.getName()).append('/');
        str.append(this.getValueType());
        return str.toString();
    }
}

