/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.executors.testng.TestRunSummary;
import com.occamlab.te.spi.vocabulary.CITE;
import com.occamlab.te.spi.vocabulary.EARL;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class EarlSuiteListener
implements ISuiteListener {
    private static final Logger LOGR = Logger.getLogger(EarlSuiteListener.class.getPackage().getName());
    private String langCode = "en";
    private Resource testRun;

    @Override
    public void onStart(ISuite suite) {
        Model model = this.initModel(suite);
        suite.setAttribute("earl", model);
    }

    @Override
    public void onFinish(ISuite suite) {
        Object obj = suite.getAttribute("earl");
        if (null == obj) {
            LOGR.warning("RDF model not obtained using suite attribute \"earl\"");
            return;
        }
        Model model = (Model)Model.class.cast(obj);
        Map<String, String> params = suite.getXmlSuite().getAllParameters();
        String testRunId = params.get("uuid");
        if (null != testRunId) {
            this.testRun.addProperty(DCTerms.identifier, testRunId);
        }
        TestRunSummary summary = new TestRunSummary(suite);
        this.testRun.addLiteral(CITE.testsPassed, new Integer(summary.getTotalPassed()));
        this.testRun.addLiteral(CITE.testsFailed, new Integer(summary.getTotalFailed()));
        this.testRun.addLiteral(CITE.testsSkipped, new Integer(summary.getTotalSkipped()));
        Literal duration = model.createTypedLiteral(summary.getTotalDuration(), (RDFDatatype)XSDDatatype.XSDduration);
        this.testRun.addLiteral(DCTerms.extent, duration);
        File outputDir = new File(suite.getOutputDirectory()).getParentFile();
        if (!outputDir.isDirectory()) {
            outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        try {
            this.writeModel(model, outputDir, true);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to serialize EARL results to " + outputDir.getAbsolutePath(), iox);
        }
    }

    Model initModel(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getAllParameters();
        LOGR.log(Level.FINE, "Test run parameters\n:" + params);
        Model model = ModelFactory.createDefaultModel();
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("earl", "http://www.w3.org/ns/earl#");
        nsBindings.put("dct", "http://purl.org/dc/terms/");
        nsBindings.put("cite", "http://cite.opengeospatial.org/");
        model.setNsPrefixes(nsBindings);
        this.testRun = model.createResource(CITE.TestRun);
        this.testRun.addProperty(DCTerms.title, suite.getName());
        String nowUTC = ZonedDateTime.now(ZoneId.of("Z")).format(DateTimeFormatter.ISO_INSTANT);
        this.testRun.addProperty(DCTerms.created, nowUTC);
        Resource assertor = model.createResource("https://github.com/opengeospatial/teamengine", EARL.Assertor);
        assertor.addProperty(DCTerms.title, "OGC TEAM Engine", this.langCode);
        assertor.addProperty(DCTerms.description, "Official test harness of the OGC conformance testing program (CITE).", this.langCode);
        String iut = params.get("iut");
        if (null == iut) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                try {
                    URI uri = URI.create(param.getValue());
                    iut = uri.toString();
                }
                catch (IllegalArgumentException e) {}
            }
        }
        if (null == iut) {
            throw new NullPointerException("Unable to find URI reference for IUT in test run parameters.");
        }
        model.createResource(iut, EARL.TestSubject);
        return model;
    }

    void writeModel(Model model, File outputDirectory, boolean abbreviated) throws IOException {
        if (!outputDirectory.isDirectory()) {
            throw new IllegalArgumentException("Directory does not exist at " + outputDirectory.getAbsolutePath());
        }
        File outputFile = new File(outputDirectory, "earl.rdf");
        if (!outputFile.createNewFile()) {
            outputFile.delete();
            outputFile.createNewFile();
        }
        LOGR.log(Level.CONFIG, "Writing EARL results to" + outputFile.getAbsolutePath());
        String syntax = abbreviated ? "RDF/XML-ABBREV" : "RDF/XML";
        String baseUri = "http://example.org/earl/" + outputDirectory.getName() + '/';
        FileOutputStream outStream = new FileOutputStream(outputFile);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outStream, StandardCharsets.UTF_8);){
            model.write(writer, syntax, baseUri);
        }
    }
}

