/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.vocabulary.EARL;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class EarlTestListener
extends TestListenerAdapter {
    private static final Logger LOGR = Logger.getLogger(EarlTestListener.class.getPackage().getName());
    private Model earlModel;
    private int resultCount = 0;
    private int nPassed = 0;
    private int nSkipped = 0;
    private int nFailed = 0;
    private Resource assertor;
    private Resource testSubject;
    private Resource testRequirement;

    @Override
    public void onStart(ITestContext testContext) {
        super.onStart(testContext);
        Object obj = testContext.getSuite().getAttribute("earl");
        if (null == obj) {
            throw new NullPointerException("RDF model not obtained using suite attribute \"earl\"");
        }
        this.earlModel = (Model)Model.class.cast(obj);
        this.assertor = (Resource)this.earlModel.listSubjectsWithProperty(RDF.type, EARL.Assertor).next();
        this.testSubject = (Resource)this.earlModel.listSubjectsWithProperty(RDF.type, EARL.TestSubject).next();
        String testName = testContext.getCurrentXmlTest().getName();
        this.testRequirement = this.earlModel.createResource(testName.replaceAll("\\s", "-"), EARL.TestRequirement);
        this.testRequirement.addProperty(DCTerms.title, testName);
        this.nFailed = 0;
        this.nSkipped = 0;
        this.nPassed = 0;
    }

    @Override
    public void onFinish(ITestContext testContext) {
        super.onFinish(testContext);
        StringBuilder summary = new StringBuilder();
        summary.append("Passed: ").append(this.nPassed).append("; ");
        summary.append("Failed: ").append(this.nFailed).append("; ");
        summary.append("Skipped: ").append(this.nSkipped);
        this.testRequirement.addProperty(DCTerms.description, summary.toString());
    }

    @Override
    public void onTestSuccess(ITestResult result) {
        super.onTestSuccess(result);
        ++this.nPassed;
        this.onTestFinish(result);
    }

    @Override
    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        ++this.nFailed;
        this.onTestFinish(result);
    }

    @Override
    public void onTestSkipped(ITestResult result) {
        super.onTestSkipped(result);
        ++this.nSkipped;
        this.onTestFinish(result);
    }

    void onTestFinish(ITestResult result) {
        LOGR.fine("Finished test method " + result.getMethod().getMethodName());
        ++this.resultCount;
        long endTime = result.getEndMillis();
        GregorianCalendar calTime = new GregorianCalendar(TimeZone.getDefault());
        calTime.setTimeInMillis(endTime);
        Resource assertion = this.earlModel.createResource("assert-" + this.resultCount, EARL.Assertion);
        assertion.addProperty(EARL.mode, EARL.AutomaticMode);
        assertion.addProperty(EARL.assertedBy, this.assertor);
        assertion.addProperty(EARL.subject, this.testSubject);
        Resource earlResult = this.earlModel.createResource("result-" + this.resultCount, EARL.TestResult);
        earlResult.addProperty(DCTerms.date, this.earlModel.createTypedLiteral(calTime));
        switch (result.getStatus()) {
            case 2: {
                earlResult.addProperty(DCTerms.description, this.getDetailMessage(result));
                if (AssertionError.class.isInstance(result.getThrowable())) {
                    earlResult.addProperty(EARL.outcome, EARL.Failed);
                    break;
                }
                earlResult.addProperty(EARL.outcome, EARL.Inconclusive);
                break;
            }
            case 3: {
                earlResult.addProperty(DCTerms.description, this.getDetailMessage(result));
                earlResult.addProperty(EARL.outcome, EARL.Untested);
                break;
            }
            default: {
                earlResult.addProperty(EARL.outcome, EARL.Passed);
            }
        }
        assertion.addProperty(EARL.result, earlResult);
        String testMethodName = result.getMethod().getMethodName();
        String testClassName = result.getTestClass().getName().replaceAll("\\.", "/");
        StringBuilder testCaseId = new StringBuilder(testClassName);
        testCaseId.append('#').append(testMethodName);
        Resource testCase = this.earlModel.createResource(testCaseId.toString(), EARL.TestCase);
        testCase.addProperty(DCTerms.title, testMethodName);
        String testDescr = result.getMethod().getDescription();
        if (null != testDescr && !testDescr.isEmpty()) {
            testCase.addProperty(DCTerms.description, testDescr);
        }
        assertion.addProperty(EARL.test, testCase);
        this.testRequirement.addProperty(DCTerms.hasPart, testCase);
    }

    String getDetailMessage(ITestResult result) {
        if (null == result.getThrowable()) {
            return "No details available.";
        }
        String msg = result.getThrowable().getMessage();
        msg = null == msg && null != result.getThrowable().getCause() ? result.getThrowable().getCause().getMessage() : result.getThrowable().toString();
        return msg;
    }
}

