/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition2D
extends Point2D.Double
implements DirectPosition,
Serializable,
Cloneable {
    private static final long serialVersionUID = 835130287438466996L;
    private CoordinateReferenceSystem crs;

    public DirectPosition2D() {
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public DirectPosition2D(double d, double d2) {
        super(d, d2);
    }

    public DirectPosition2D(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2) {
        super(d, d2);
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public DirectPosition2D(Point2D point2D) {
        super(point2D.getX(), point2D.getY());
        if (point2D instanceof DirectPosition) {
            this.setCoordinateReferenceSystem(((DirectPosition)((Object)point2D)).getCoordinateReferenceSystem());
        }
    }

    public DirectPosition2D(DirectPosition directPosition) throws MismatchedDimensionException {
        this.setLocation(directPosition);
    }

    public DirectPosition2D(String string) throws NumberFormatException, IllegalArgumentException {
        int n;
        double[] dArray = AbstractDirectPosition.parse(string);
        int n2 = n = dArray != null ? dArray.length : 0;
        if (n != 2) {
            throw new MismatchedDimensionException(Errors.format(113, string, n, 2));
        }
        this.x = dArray[0];
        this.y = dArray[1];
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public double[] getCoordinate() {
        return new double[]{this.x, this.y};
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(Errors.format(96, n));
    }

    @Override
    public final void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        switch (n) {
            case 0: {
                this.x = d;
                break;
            }
            case 1: {
                this.y = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Errors.format(96, n));
            }
        }
    }

    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), 2);
        this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
        this.x = directPosition.getOrdinate(0);
        this.y = directPosition.getOrdinate(1);
    }

    public Point2D toPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    @Override
    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            if (directPosition.getDimension() == 2 && Utilities.equals(directPosition.getOrdinate(0), this.x) && Utilities.equals(directPosition.getOrdinate(1), this.y) && Utilities.equals(directPosition.getCoordinateReferenceSystem(), this.crs)) {
                assert (this.hashCode() == ((Object)directPosition).hashCode()) : this;
                return true;
            }
            return false;
        }
        return super.equals(object);
    }

    @Override
    public DirectPosition2D clone() {
        return (DirectPosition2D)super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeDouble(this.x);
        objectOutputStream.writeDouble(this.y);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.x = objectInputStream.readDouble();
        this.y = objectInputStream.readDouble();
    }
}

