/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.v311.GridType;
import org.geotoolkit.gml.xml.v311.PointType;
import org.geotoolkit.gml.xml.v311.VectorType;
import org.opengis.coverage.grid.RectifiedGrid;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RectifiedGridType", propOrder={"origin", "offsetVector"})
public class RectifiedGridType
extends GridType {
    @XmlElement(required=true)
    private PointType origin;
    @XmlElement(required=true)
    private List<VectorType> offsetVector;

    public RectifiedGridType() {
    }

    public RectifiedGridType(RectifiedGrid grid) {
        super(grid);
        if (grid != null) {
            this.origin = new PointType(grid.getOrigin(), false);
            this.offsetVector = new ArrayList<VectorType>();
            List<double[]> vectors = grid.getOffsetVectors();
            for (double[] vector : vectors) {
                this.offsetVector.add(new VectorType(vector));
            }
        }
    }

    public PointType getOrigin() {
        return this.origin;
    }

    public void setOrigin(PointType origin) {
        this.origin = origin;
    }

    public List<VectorType> getOffsetVector() {
        return this.offsetVector;
    }

    public void setOffsetVector(List<VectorType> offsetVector) {
        this.offsetVector = offsetVector;
    }
}

