/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.InvalidMetadataException;
import org.geotoolkit.metadata.ModifiableMetadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="EX_Extent_Type", propOrder={"description", "geographicElements", "temporalElements", "verticalElements"})
@XmlRootElement(name="EX_Extent")
public class DefaultExtent
extends MetadataEntity
implements Extent {
    private static final long serialVersionUID = 7812213837337326257L;
    public static final Extent WORLD;
    private InternationalString description;
    private Collection<GeographicExtent> geographicElements;
    private Collection<TemporalExtent> temporalElements;
    private Collection<VerticalExtent> verticalElements;

    public DefaultExtent() {
    }

    public DefaultExtent(Extent extent) {
        super(extent);
    }

    public DefaultExtent(Envelope envelope) throws TransformException {
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public static DefaultExtent castOrCopy(Extent extent) {
        return extent == null || extent instanceof DefaultExtent ? (DefaultExtent)extent : new DefaultExtent(extent);
    }

    @Override
    @XmlElement(name="description")
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="geographicElement")
    public synchronized Collection<GeographicExtent> getGeographicElements() {
        this.geographicElements = this.nonNullCollection(this.geographicElements, GeographicExtent.class);
        return this.geographicElements;
    }

    public synchronized void setGeographicElements(Collection<? extends GeographicExtent> collection) {
        this.geographicElements = this.copyCollection(collection, this.geographicElements, GeographicExtent.class);
    }

    @XmlElement(name="temporalElement")
    public synchronized Collection<TemporalExtent> getTemporalElements() {
        this.temporalElements = this.nonNullCollection(this.temporalElements, TemporalExtent.class);
        return this.temporalElements;
    }

    public synchronized void setTemporalElements(Collection<? extends TemporalExtent> collection) {
        this.temporalElements = this.copyCollection(collection, this.temporalElements, TemporalExtent.class);
    }

    @XmlElement(name="verticalElement")
    public synchronized Collection<VerticalExtent> getVerticalElements() {
        this.verticalElements = this.nonNullCollection(this.verticalElements, VerticalExtent.class);
        return this.verticalElements;
    }

    public synchronized void setVerticalElements(Collection<? extends VerticalExtent> collection) {
        this.verticalElements = this.copyCollection(collection, this.verticalElements, VerticalExtent.class);
    }

    public synchronized void addElements(Envelope envelope) throws TransformException {
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public static GeographicBoundingBox getGeographicBoundingBox(Extent extent) {
        Object object = null;
        if (extent != null) {
            ModifiableMetadata modifiableMetadata = null;
            for (GeographicExtent geographicExtent : extent.getGeographicElements()) {
                if (!(geographicExtent instanceof GeographicBoundingBox)) {
                    if (!(geographicExtent instanceof BoundingPolygon)) continue;
                    continue;
                }
                GeographicBoundingBox geographicBoundingBox = (GeographicBoundingBox)geographicExtent;
                if (object == null) {
                    Boolean bl = geographicBoundingBox.getInclusion();
                    DefaultExtent.ensureNonNull("inclusion", bl);
                    if (!bl.booleanValue()) continue;
                    object = geographicBoundingBox;
                    continue;
                }
                if (modifiableMetadata == null) {
                    modifiableMetadata = new DefaultGeographicBoundingBox((GeographicBoundingBox)object);
                    object = modifiableMetadata;
                }
                ((DefaultGeographicBoundingBox)modifiableMetadata).add(geographicBoundingBox);
            }
            if (modifiableMetadata != null) {
                modifiableMetadata.freeze();
            }
        }
        return object;
    }

    static void ensureNonNull(String string, Object object) throws InvalidMetadataException {
        if (object == null) {
            throw new InvalidMetadataException(Errors.format(173, string));
        }
    }

    static {
        DefaultExtent defaultExtent = new DefaultExtent();
        defaultExtent.setGeographicElements(Collections.singleton(DefaultGeographicBoundingBox.WORLD));
        defaultExtent.freeze();
        WORLD = defaultExtent;
    }
}

