/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.AbstractParameterDescriptor;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.parameter.ParameterWriter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@Immutable
public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -4613190550542423839L;
    private final int maximumOccurs;
    private final GeneralParameterDescriptor[] parameters;
    private transient List<GeneralParameterDescriptor> asList;

    public DefaultParameterDescriptorGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
        this.maximumOccurs = parameterDescriptorGroup.getMaximumOccurs();
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.parameters = list.toArray(new GeneralParameterDescriptor[list.size()]);
    }

    public DefaultParameterDescriptorGroup(String string, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        this(Collections.singletonMap("name", string), generalParameterDescriptorArray);
    }

    public DefaultParameterDescriptorGroup(Citation citation, String string, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        this(Collections.singletonMap("name", new NamedIdentifier(citation, string)), generalParameterDescriptorArray);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> map, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        this(map, 1, 1, generalParameterDescriptorArray);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> map, int n, int n2, GeneralParameterDescriptor ... generalParameterDescriptorArray) {
        super(map, n, n2);
        int n3;
        this.maximumOccurs = n2;
        ArgumentChecks.ensureNonNull("parameters", generalParameterDescriptorArray);
        this.parameters = new GeneralParameterDescriptor[generalParameterDescriptorArray.length];
        for (n3 = 0; n3 < generalParameterDescriptorArray.length; ++n3) {
            this.parameters[n3] = generalParameterDescriptorArray[n3];
            ArgumentChecks.ensureNonNull("parameters", n3, generalParameterDescriptorArray);
        }
        generalParameterDescriptorArray = this.parameters;
        for (n3 = 0; n3 < generalParameterDescriptorArray.length; ++n3) {
            String string = generalParameterDescriptorArray[n3].getName().getCode();
            for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                if (n3 == i || !IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterDescriptorArray[i], string)) continue;
                throw new InvalidParameterNameException(Errors.format(182, generalParameterDescriptorArray[i].getName().getCode(), i, string, n3), string);
            }
        }
    }

    @Override
    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    @Override
    public ParameterValueGroup createValue() {
        return new ParameterGroup(this);
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        if (this.asList == null) {
            if (this.parameters == null) {
                this.asList = Collections.emptyList();
            } else {
                switch (this.parameters.length) {
                    case 0: {
                        this.asList = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        this.asList = Collections.singletonList(this.parameters[0]);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.asList = UnmodifiableArrayList.wrap(this.parameters);
                        break;
                    }
                    default: {
                        this.asList = new AsList(this.parameters);
                    }
                }
            }
        }
        return this.asList;
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        ArgumentChecks.ensureNonNull("name", string);
        string = string.trim();
        LinkedList<DefaultParameterDescriptorGroup> linkedList = null;
        List<GeneralParameterDescriptor> list = this.descriptors();
        while (list != null) {
            for (GeneralParameterDescriptor generalParameterDescriptor : list) {
                if (IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterDescriptor, string)) {
                    return generalParameterDescriptor;
                }
                if (!(generalParameterDescriptor instanceof DefaultParameterDescriptorGroup)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<DefaultParameterDescriptorGroup>();
                }
                assert (!linkedList.contains(generalParameterDescriptor)) : generalParameterDescriptor;
                linkedList.add((DefaultParameterDescriptorGroup)generalParameterDescriptor);
            }
            if (XCollections.isNullOrEmpty(linkedList)) break;
            list = ((DefaultParameterDescriptorGroup)linkedList.remove(0)).descriptors();
        }
        throw new ParameterNotFoundException(Errors.format(224, string), string);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultParameterDescriptorGroup defaultParameterDescriptorGroup = (DefaultParameterDescriptorGroup)object;
                    return this.maximumOccurs == defaultParameterDescriptorGroup.maximumOccurs && Arrays.equals(this.parameters, defaultParameterDescriptorGroup.parameters);
                }
            }
            ParameterDescriptorGroup parameterDescriptorGroup = (ParameterDescriptorGroup)object;
            return Utilities.deepEquals(this.descriptors(), parameterDescriptorGroup.descriptors(), comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(Arrays.hashCode(this.parameters), super.computeHashCode());
    }

    @Override
    public String toString() {
        return ParameterWriter.toString(this);
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
            super(generalParameterDescriptorArray);
        }

        @Override
        public boolean contains(Object object) {
            if (this.asSet == null) {
                this.asSet = new HashSet<GeneralParameterDescriptor>(this);
            }
            return this.asSet.contains(object);
        }
    }
}

