/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import java.util.logging.Logger;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.JAXBException;
import javax.xml.transform.dom.DOMSource;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.GeometrytoJTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.Curve;
import org.geotoolkit.referencing.CRS;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.SpatialOperator;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TopologicalRelationships {
    private static final Logger LOGR = Logger.getLogger(TopologicalRelationships.class.getPackage().getName());

    public static boolean isSpatiallyRelated(SpatialOperator predicate, Node node1, Node node2) {
        Geometry g1 = TopologicalRelationships.toJTSGeometry(TopologicalRelationships.unmarshal(node1));
        Geometry g2 = TopologicalRelationships.toJTSGeometry(TopologicalRelationships.unmarshal(node2));
        try {
            g1 = TopologicalRelationships.setCRS(g1, JTS.findCoordinateReferenceSystem(g2));
        }
        catch (TransformException | FactoryException e) {
            throw new RuntimeException(e);
        }
        boolean isRelated = false;
        switch (predicate) {
            case INTERSECTS: {
                isRelated = g1.intersects(g2);
                break;
            }
            case DISJOINT: {
                isRelated = !g1.intersects(g2);
                break;
            }
            case TOUCHES: {
                isRelated = g1.touches(g2);
                break;
            }
            case WITHIN: {
                isRelated = g1.within(g2);
                break;
            }
            case OVERLAPS: {
                isRelated = g1.overlaps(g2);
                break;
            }
            case CROSSES: {
                isRelated = g1.crosses(g2);
                break;
            }
            case CONTAINS: {
                isRelated = g1.contains(g2);
                break;
            }
            case EQUALS: {
                isRelated = g1.equalsTopo(g2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported spatial predicate: " + (Object)((Object)predicate));
            }
        }
        return isRelated;
    }

    public static boolean isWithinDistance(Node geom1, Node geom2, Element distanceWithUom) {
        double orthodromicDist;
        Geometry g1 = TopologicalRelationships.toJTSGeometry(TopologicalRelationships.unmarshal(geom1));
        Geometry g2 = TopologicalRelationships.toJTSGeometry(TopologicalRelationships.unmarshal(geom2));
        try {
            g1 = TopologicalRelationships.setCRS(g1, JTS.findCoordinateReferenceSystem(g2));
            CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(g1);
            Coordinate[] nearestPoints = DistanceOp.nearestPoints(g1, g2);
            orthodromicDist = JTS.orthodromicDistance(nearestPoints[0], nearestPoints[1], crs1);
        }
        catch (TransformException | FactoryException e) {
            throw new RuntimeException(e);
        }
        double maxDistance = Double.parseDouble(distanceWithUom.getTextContent());
        String uomId = distanceWithUom.getAttribute("uom");
        LOGR.fine(String.format("Max distance = %s %s; calculated orthodromic distance = %s m", maxDistance, uomId, orthodromicDist));
        Unit<?> uom = null;
        if (!uomId.contains(":")) {
            uom = Unit.valueOf(uomId);
        }
        UnitConverter converter = uom.getConverterTo(SI.METRE);
        return orthodromicDist < converter.convert(maxDistance);
    }

    public static boolean isBeyond(Node g1, Node g2, Element distanceWithUom) {
        return !TopologicalRelationships.isWithinDistance(g1, g2, distanceWithUom);
    }

    static Geometry toJTSGeometry(AbstractGeometry gmlGeom) {
        Geometry jtsGeom;
        block3: {
            jtsGeom = null;
            try {
                jtsGeom = GeometrytoJTS.toJTS(gmlGeom);
            }
            catch (FactoryException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalArgumentException e2) {
                if (!Curve.class.isInstance(gmlGeom)) break block3;
                jtsGeom = GmlUtils.buildLineString((Curve)Curve.class.cast(gmlGeom));
            }
        }
        LOGR.fine(String.format("Resulting JTS geometry:\n  %s", jtsGeom.toText()));
        return jtsGeom;
    }

    static AbstractGeometry unmarshal(Node geomNode) {
        AbstractGeometry gmlGeom;
        if (!geomNode.getNamespaceURI().equals("http://www.opengis.net/gml/3.2")) {
            throw new IllegalArgumentException(String.format("Node not in GML namespace: ", geomNode.getNamespaceURI()));
        }
        GmlUtils.setSrsNameOnCollectionMembers(geomNode);
        try {
            gmlGeom = GmlUtils.unmarshalGMLGeometry(new DOMSource(geomNode));
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        gmlGeom.setSrsName(GeodesyUtils.convertSRSNameToURN(gmlGeom.getSrsName()));
        return gmlGeom;
    }

    static Geometry setCRS(Geometry g1, CoordinateReferenceSystem crs) throws FactoryException, TransformException {
        CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(g1);
        Geometry g2 = null;
        if (!crs1.getName().equals(crs.getName())) {
            LOGR.fine(String.format("Attempting to change CRS %s to %s", crs1.getName(), crs.getName()));
            MathTransform transform = CRS.findMathTransform(crs1, crs);
            g2 = JTS.transform(g1, transform);
            JTS.setCRS(g2, crs);
        }
        return null != g2 ? g2 : g1;
    }
}

