/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter.temporal;

import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.time.TemporalUtils;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.basic.filter.temporal.TemporalQuery;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TimeUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalGeometricPrimitive;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeforeTests
extends QueryFilterFixture {
    private static final String BEFORE_OP = "Before";

    @BeforeClass
    public void implementsBeforeOperator() {
        if (!ServiceMetadataUtils.implementsTemporalOperator(this.wfsMetadata, BEFORE_OP)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", "Before operator"));
        }
    }

    @Test(description="See ISO 19143: A.10", dataProvider="protocol-featureType")
    public void beforePeriod(ProtocolBinding binding, QName featureType) {
        List<XSElementDeclaration> timeProps = this.findTemporalProperties(featureType);
        if (timeProps.isEmpty()) {
            throw new SkipException("Feature type has no temporal properties: " + featureType);
        }
        XSElementDeclaration timeProperty = timeProps.get(0);
        Period temporalExtent = this.dataSampler.getTemporalExtentOfProperty(this.model, featureType, timeProperty);
        List<Period> subIntervals = TemporalUtils.splitInterval(temporalExtent, 2);
        Period lastSubInterval = subIntervals.get(1);
        Document gmlTimeLiteral = TimeUtils.periodAsGML(lastSubInterval);
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        Element valueRef = WFSMessage.createValueReference(timeProperty);
        WFSMessage.addTemporalPredicate(this.reqEntity, BEFORE_OP, gmlTimeLiteral, valueRef);
        ClientResponse rsp = this.wfsClient.getFeature(new DOMSource(this.reqEntity), binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals(rsp.getStatus(), ClientResponse.Status.OK.getStatusCode(), ErrorMessage.get("UnexpectedStatus"));
        List<Node> temporalNodes = TemporalQuery.extractTemporalNodes(this.rspEntity, timeProperty, this.model);
        this.assertBefore(temporalNodes, timeProperty, gmlTimeLiteral);
    }

    void assertBefore(List<Node> temporalNodes, XSElementDeclaration propertyDecl, Document gmlTimeLiteral) {
        Assert.assertFalse(temporalNodes.isEmpty(), String.format("No temporal values found in results: property is %s.", propertyDecl));
        TemporalGeometricPrimitive t2 = GmlUtils.gmlToTemporalGeometricPrimitive(gmlTimeLiteral.getDocumentElement());
        XSTypeDefinition typeDef = propertyDecl.getTypeDefinition();
        for (Node timeNode : temporalNodes) {
            TemporalGeometricPrimitive t1 = null;
            t1 = typeDef.getTypeCategory() == 16 ? TemporalQuery.parseTemporalValue(timeNode.getTextContent(), typeDef) : GmlUtils.gmlToTemporalGeometricPrimitive((Element)timeNode);
            TemporalUtils.assertTemporalRelation(RelativePosition.BEFORE, t1, t2);
        }
    }
}

