/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DescribeStoredQueriesTests
extends BaseFixture {
    private Schema wfsSchema;

    @BeforeClass
    public void setupClassFixture(ITestContext testContext) {
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull(this.wfsSchema, "WFS schema not found in suite fixture.");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.reqEntity = builder.parse(this.getClass().getResourceAsStream("DescribeStoredQueries.xml"));
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse request entity from classpath", e);
        }
    }

    @BeforeMethod
    public void clearQueryIdentifiers() {
        this.removeAllQueryIdentifiers(this.reqEntity);
    }

    @Test(description="See ISO 19142: 14.4.2, Table 21", dataProvider="protocol-binding")
    public void describeAllStoredQueries(ProtocolBinding binding) {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DescribeStoredQueries", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Validator validator = this.wfsSchema.newValidator();
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errHandler);
        try {
            validator.validate(new DOMSource(this.rspEntity, this.rspEntity.getDocumentURI()));
        }
        catch (Exception ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to validate WFS capabilities document", ex);
        }
        Assert.assertFalse(errHandler.errorsDetected(), ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
        String xpath = "count(//wfs:StoredQueryDescription) > 0";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 7.9.3.6", dataProvider="protocol-binding")
    public void describeStoredQuery_GetFeatureById(ProtocolBinding binding) {
        String queryId = this.wfsVersion.equals("2.0.0") ? "urn:ogc:def:query:OGC-WFS::GetFeatureById" : "http://www.opengis.net/def/query/OGC-WFS/0/GetFeatureById";
        this.addQueryIdentifier(this.reqEntity, queryId);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "DescribeStoredQueries", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue(rsp.hasEntity(), ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp);
        String xpath = String.format("//wfs:StoredQueryDescription[@id='%s']", queryId);
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    void removeAllQueryIdentifiers(Document reqEntity) {
        Element docElem = reqEntity.getDocumentElement();
        NodeList children = docElem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            docElem.removeChild(children.item(i));
        }
    }

    void addQueryIdentifier(Document request, String queryId) {
        Element docElem = this.reqEntity.getDocumentElement();
        Element storedQueryId = request.createElementNS("http://www.opengis.net/wfs/2.0", "StoredQueryId");
        storedQueryId.setTextContent(queryId);
        docElem.appendChild(storedQueryId);
    }
}

