/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.iso19142.Namespaces;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.URIUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidationUtils {
    private static final XMLCatalogResolver SCH_RESOLVER = ValidationUtils.initCatalogResolver();
    static final String ROOT_PKG = "/org/opengis/cite/iso19142/";

    private static XMLCatalogResolver initCatalogResolver() {
        return (XMLCatalogResolver)ValidationUtils.createSchemaResolver(Namespaces.SCH);
    }

    public static LSResourceResolver createSchemaResolver(URI schemaLanguage) {
        String catalogFileName = schemaLanguage.equals(Namespaces.XSD) ? "schema-catalog.xml" : "schematron-catalog.xml";
        URL catalogURL = ValidationUtils.class.getResource(ROOT_PKG + catalogFileName);
        XMLCatalogResolver resolver2 = new XMLCatalogResolver();
        resolver2.setCatalogList(new String[]{catalogURL.toString()});
        return resolver2;
    }

    public static SchematronValidator buildSchematronValidator(String schemaRef, String phase) {
        StreamSource source = null;
        try {
            String catalogRef = SCH_RESOLVER.resolveSystem(schemaRef.toString());
            source = null != catalogRef ? new StreamSource(URI.create(catalogRef).toString()) : new StreamSource(schemaRef);
        }
        catch (IOException x) {
            TestSuiteLogger.log(Level.WARNING, "Error reading Schematron schema catalog.", x);
        }
        SchematronValidator validator = null;
        try {
            validator = new SchematronValidator(source, phase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Error creating Schematron validator.", e);
        }
        return validator;
    }

    public static URI extractSchemaReference(Source source, String baseURI) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(source);
        StartElement docElem = reader.nextTag().asStartElement();
        QName qName = docElem.getName();
        String namespace = qName.getNamespaceURI();
        Attribute schemaLoc = docElem.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        String[] uriValues = new String[]{};
        if (null != schemaLoc) {
            uriValues = schemaLoc.getValue().split("\\s");
        }
        URI schemaURI = null;
        for (int i = 0; i < uriValues.length; i += 2) {
            if (!uriValues[i].equals(namespace)) continue;
            if (!URI.create(uriValues[i + 1]).isAbsolute() && null != source.getSystemId()) {
                String schemaRef = URIUtils.resolveRelativeURI(source.getSystemId(), uriValues[i + 1]);
                if (schemaRef.startsWith("file") && !new File(schemaRef).exists() && null != baseURI) {
                    schemaRef = URIUtils.resolveRelativeURI(baseURI, uriValues[i + 1]);
                }
                schemaURI = URI.create(schemaRef);
                break;
            }
            schemaURI = URI.create(uriValues[i + 1]);
            break;
        }
        return schemaURI;
    }

    public static Schema createWFSSchema() {
        URL entityCatalog = ValidationUtils.class.getResource("/org/opengis/cite/iso19142/schema-catalog.xml");
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(entityCatalog);
        Schema wfsSchema = null;
        try {
            URL schemaURL = ValidationUtils.class.getResource("/org/opengis/cite/iso19142/xsd/opengis/wfs/2.0/wfs-2.0.0.xsd");
            StreamSource xsdSource = new StreamSource(schemaURL.toString());
            wfsSchema = xsdCompiler.compileXmlSchema(xsdSource);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create WFS Schema object.", e);
        }
        return wfsSchema;
    }
}

