/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ComparisonOperatorTests
extends QueryFilterFixture {
    private static String MATCH_ALL = "All";
    private static String MATCH_ANY = "Any";

    @Test(description="See ISO 19143: 7.7", dataProvider="protocol-featureType")
    public void propertyIsLessThan_matchAny(ProtocolBinding binding, QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(AppSchemaUtils.getSimpleTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        if (propRangeMap.isEmpty()) {
            throw new SkipException("No numeric or temporal property values found for " + featureType);
        }
        Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
        String propValue = propRange.getValue()[1];
        XSElementDeclaration propDecl = propRange.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.addComparisonPredicate(this.reqEntity, "PropertyIsLessThan", propName, propValue, true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s) lt xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.3", dataProvider="protocol-featureType")
    public void propertyIsLessThan_matchAll(ProtocolBinding binding, QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(AppSchemaUtils.getSimpleTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        if (propRangeMap.isEmpty()) {
            throw new SkipException("No numeric or temporal property values found for " + featureType);
        }
        Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
        String propValue = propRange.getValue()[1];
        XSElementDeclaration propDecl = propRange.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.addComparisonPredicate(this.reqEntity, "PropertyIsLessThan", propName, propValue, true, MATCH_ALL);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s) lt xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.1", dataProvider="protocol-featureType")
    public void propertyIsGreaterThan_matchAny(ProtocolBinding binding, QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(AppSchemaUtils.getSimpleTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        if (propRangeMap.isEmpty()) {
            throw new SkipException("No numeric or temporal property values found for " + featureType);
        }
        Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
        String propValue = propRange.getValue()[0];
        XSElementDeclaration propDecl = propRange.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.addComparisonPredicate(this.reqEntity, "PropertyIsGreaterThan", propName, propValue, true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s) gt xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.1", dataProvider="protocol-featureType")
    public void propertyIsGreaterThanEqualTo_matchAny(ProtocolBinding binding, QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(AppSchemaUtils.getSimpleTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        if (propRangeMap.isEmpty()) {
            throw new SkipException("No numeric or temporal property values found for " + featureType);
        }
        Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
        String propValue = propRange.getValue()[0];
        XSElementDeclaration propDecl = propRange.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.addComparisonPredicate(this.reqEntity, "PropertyIsGreaterThanOrEqualTo", propName, propValue, true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s) ge xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.1", dataProvider="protocol-featureType")
    public void propertyIsLessThanEqualTo_matchAny(ProtocolBinding binding, QName featureType) {
        Set<XSTypeDefinition> dataTypes = this.getNumericDataTypes(this.model);
        dataTypes.addAll(AppSchemaUtils.getSimpleTemporalDataTypes(this.model));
        Map<XSElementDeclaration, String[]> propRangeMap = this.findFeaturePropertyValue(this.model, featureType, dataTypes);
        if (propRangeMap.isEmpty()) {
            throw new SkipException("No numeric or temporal property values found for " + featureType);
        }
        Map.Entry<XSElementDeclaration, String[]> propRange = propRangeMap.entrySet().iterator().next();
        String propValue = propRange.getValue()[1];
        XSElementDeclaration propDecl = propRange.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.addComparisonPredicate(this.reqEntity, "PropertyIsLessThanOrEqualTo", propName, propValue, true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s) le xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue);
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 8.3", dataProvider="protocol-binding")
    public void invalidPropertyReference(ProtocolBinding binding) {
        QName propName = new QName("http://example.org", "undefined", "ex");
        Random rnd = new Random();
        int index = rnd.nextInt(this.featureTypes.size());
        WFSMessage.appendSimpleQuery(this.reqEntity, (QName)this.featureTypes.get(index));
        this.addComparisonPredicate(this.reqEntity, "PropertyIsLessThanOrEqualTo", propName, "1355941270", true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode='InvalidParameterValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity, null);
    }

    @Test(description="See ISO 19142: 7.5, 11.4", dataProvider="protocol-binding")
    public void invalidOperand_boundedBy(ProtocolBinding binding) {
        QName propName = new QName("http://www.opengis.net/gml/3.2", "boundedBy", "gml");
        Random rnd = new Random();
        int index = rnd.nextInt(this.featureTypes.size());
        WFSMessage.appendSimpleQuery(this.reqEntity, (QName)this.featureTypes.get(index));
        Document gmlEnv = WFSMessage.createGMLEnvelope();
        this.addComparisonPredicate(this.reqEntity, "PropertyIsLessThanOrEqualTo", propName, gmlEnv, true, MATCH_ANY);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        ETSAssert.assertStatusCode(rsp.getStatus(), new int[]{400, 403});
        String xpath = "//ows:Exception[@exceptionCode='OperationProcessingFailed']";
        ETSAssert.assertXPath(xpath, this.rspEntity, null);
    }

    void addComparisonPredicate(Document request, String operator, QName propertyName, Object literalValue, boolean matchCase, String matchAction) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", operator);
        filter.appendChild(predicate);
        String matchActionAttr = null != matchAction && !matchAction.isEmpty() ? matchAction : MATCH_ANY;
        predicate.setAttribute("matchCase", Boolean.toString(matchCase));
        predicate.setAttribute("matchAction", matchActionAttr);
        Element literalElem = request.createElementNS("http://www.opengis.net/fes/2.0", "Literal");
        if (String.class.isInstance(literalValue)) {
            literalElem.setTextContent((String)literalValue);
        } else {
            Document literalDoc = (Document)literalValue;
            literalElem.appendChild(request.adoptNode(literalDoc.getDocumentElement()));
        }
        predicate.appendChild(literalElem);
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }

    Map<XSElementDeclaration, String[]> findFeaturePropertyValue(XSModel model, QName featureType, Set<XSTypeDefinition> dataTypes) {
        XSTypeDefinition dataType;
        List<XSElementDeclaration> featureProps = null;
        Iterator<XSTypeDefinition> iterator = dataTypes.iterator();
        while (iterator.hasNext() && (featureProps = AppSchemaUtils.getFeaturePropertiesByType(model, featureType, dataType = iterator.next())).isEmpty()) {
        }
        ListIterator listItr = featureProps.listIterator(featureProps.size());
        XSElementDeclaration prop = null;
        Object[] valueRange = null;
        while (listItr.hasPrevious()) {
            prop = (XSElementDeclaration)listItr.previous();
            QName propName = new QName(prop.getNamespace(), prop.getName());
            List<String> valueList = this.dataSampler.getSimplePropertyValues(featureType, propName, null);
            if (valueList.isEmpty()) continue;
            String[] values = new String[valueList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = valueList.get(i);
            }
            QName datatype = AppSchemaUtils.getBuiltInDatatype(prop);
            valueRange = this.calculateRange(values, datatype);
            TestSuiteLogger.log(Level.FINE, String.format("Found property values of %s, %s \n %s", featureType, propName, Arrays.toString(valueRange)));
            break;
        }
        HashMap<XSElementDeclaration, String[]> map = new HashMap<XSElementDeclaration, String[]>();
        if (null != valueRange) {
            map.put(prop, (String[])valueRange);
        }
        return map;
    }

    String[] calculateRange(String[] values, QName datatype) {
        this.sortValues(values);
        HashSet integerDatatypes = new HashSet();
        Collections.addAll(integerDatatypes, "integer", "nonPositiveInteger", "nonNegativeInteger", "long", "int");
        if (integerDatatypes.contains(datatype.getLocalPart())) {
            for (int i = 0; i < values.length; ++i) {
                int intValue = Double.valueOf(values[i]).intValue();
                values[i] = Integer.toString(intValue);
            }
        }
        return new String[]{values[0], values[values.length - 1]};
    }

    void sortValues(String[] values) {
        DatatypeFactory dtFactory;
        int i;
        if (null == values || values.length == 0) {
            return;
        }
        Comparable<Double>[] objValues = null;
        try {
            objValues = new Double[values.length];
            for (int i2 = 0; i2 < objValues.length; ++i2) {
                objValues[i2] = Double.valueOf(values[i2]);
            }
            Arrays.sort(objValues);
        }
        catch (NumberFormatException nfe) {
            objValues = new Calendar[values.length];
            for (i = 0; i < objValues.length; ++i) {
                objValues[i] = values[i].indexOf(84) > 0 ? DatatypeConverter.parseDateTime((String)values[i]) : DatatypeConverter.parseDate((String)values[i]);
            }
            Arrays.sort(objValues);
        }
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        for (i = 0; i < values.length; ++i) {
            if (GregorianCalendar.class.isInstance(objValues[i])) {
                GregorianCalendar gCal = (GregorianCalendar)objValues[i];
                values[i] = dtFactory.newXMLGregorianCalendar(gCal).normalize().toString();
                continue;
            }
            values[i] = DatatypeConverter.printDecimal((BigDecimal)new BigDecimal(objValues[i].toString()));
        }
    }

    Set<XSTypeDefinition> getNumericDataTypes(XSModel model) {
        HashSet<XSTypeDefinition> dataTypes = new HashSet<XSTypeDefinition>();
        dataTypes.add(model.getTypeDefinition("decimal", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("double", "http://www.w3.org/2001/XMLSchema"));
        dataTypes.add(model.getTypeDefinition("float", "http://www.w3.org/2001/XMLSchema"));
        return dataTypes;
    }
}

