/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.w3c.dom.Element;

public class ResourceId {
    private final String rid;
    private String previousRid;
    private String version;
    private String start;
    private String end;
    DateTimeFormatter dateTimeFormatter;

    public ResourceId(String rid) {
        this.rid = rid;
        this.dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]");
    }

    public String getRid() {
        return this.rid;
    }

    public String getPreviousRid() {
        return this.previousRid;
    }

    public void setPreviousRid(String previousRid) {
        this.previousRid = previousRid;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String startDateTime) {
        try {
            this.dateTimeFormatter.parse(startDateTime);
            this.start = startDateTime;
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String endDateTime) {
        try {
            this.dateTimeFormatter.parse(endDateTime);
            this.end = endDateTime;
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ResourceId [rid=").append(this.rid);
        str.append(", previousRid=").append(this.previousRid);
        str.append(", version=").append(this.version);
        str.append(", start=").append(this.start);
        str.append(", end=").append(this.end).append(']');
        return str.toString();
    }

    public Element toElement() {
        Element resourceId = XMLUtils.createElement(new QName("http://www.opengis.net/fes/2.0", "ResourceId"));
        resourceId.setAttribute("rid", this.rid);
        if (null != this.previousRid) {
            resourceId.setAttribute("previousRid", this.previousRid);
        }
        if (null != this.version) {
            resourceId.setAttribute("version", this.version);
        }
        if (null != this.start) {
            resourceId.setAttribute("startDate", this.start);
        }
        if (null != this.end) {
            resourceId.setAttribute("endDate", this.end);
        }
        return resourceId;
    }
}

