/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.joins;

import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.geomatics.SpatialOperator;
import org.opengis.cite.iso19142.ConformanceClass;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.joins.JoinQueryUtils;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.FeatureProperty;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SpatialJoinTests
extends QueryFilterFixture {
    public static final String IMPL_SPATIAL_JOINS = "ImplementsSpatialJoins";
    private static final Logger LOGR = Logger.getLogger(SpatialJoinTests.class.getPackage().getName());
    private Map<QName, List<XSElementDeclaration>> surfaceProps;
    private Map<QName, List<XSElementDeclaration>> curveProps;
    private Map<QName, List<XSElementDeclaration>> pointProps;
    private Map<SpatialOperator, Set<QName>> spatialCapabilities;

    Map<QName, List<XSElementDeclaration>> findGeometryProperties(String gmlTypeName) {
        HashMap<QName, List<XSElementDeclaration>> geomProps = new HashMap<QName, List<XSElementDeclaration>>();
        XSTypeDefinition gmlGeomBaseType = this.model.getTypeDefinition(gmlTypeName, "http://www.opengis.net/gml/3.2");
        for (QName featureType : this.featureTypes) {
            List<XSElementDeclaration> geomPropsList = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, gmlGeomBaseType);
            if (geomPropsList.isEmpty()) continue;
            geomProps.put(featureType, geomPropsList);
        }
        return geomProps;
    }

    @BeforeTest
    public void implementsSpatialJoins(ITestContext testContext) {
        NodeList result;
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]", IMPL_SPATIAL_JOINS);
        try {
            result = XMLUtils.evaluateXPath(this.wfsMetadata, xpath, null);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e.getMessage());
        }
        if (result.getLength() == 0) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", ConformanceClass.SPATIAL_JOINS.getConstraintName()));
        }
    }

    @BeforeClass
    public void initFixture() {
        this.spatialCapabilities = ServiceMetadataUtils.getSpatialCapabilities(this.wfsMetadata);
        this.surfaceProps = this.findGeometryProperties("AbstractSurfaceType");
        if (this.surfaceProps.isEmpty()) {
            this.surfaceProps = this.findGeometryProperties("MultiSurfaceType");
        }
        LOGR.info(this.surfaceProps.toString());
        this.curveProps = this.findGeometryProperties("AbstractCurveType");
        if (this.curveProps.isEmpty()) {
            this.curveProps = this.findGeometryProperties("MultiCurveType");
        }
        LOGR.info(this.curveProps.toString());
        this.pointProps = this.findGeometryProperties("PointType");
        if (this.pointProps.isEmpty()) {
            this.pointProps = this.findGeometryProperties("MultiPointType");
        }
        LOGR.info(this.pointProps.toString());
    }

    @Test(description="See OGC 09-025r2: 7.9.2.5.3, A.1.12")
    public void joinWithIntersects() {
        if (!this.spatialCapabilities.keySet().contains(SpatialOperator.INTERSECTS)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", SpatialOperator.INTERSECTS));
        }
        ArrayList<FeatureProperty> joinProperties = new ArrayList<FeatureProperty>();
        if (this.surfaceProps.size() > 1) {
            Iterator<Map.Entry<QName, List<XSElementDeclaration>>> itr = this.surfaceProps.entrySet().iterator();
            Map.Entry<QName, List<XSElementDeclaration>> entry = itr.next();
            joinProperties.add(new FeatureProperty(entry.getKey(), entry.getValue().get(0)));
            entry = itr.next();
            joinProperties.add(new FeatureProperty(entry.getKey(), entry.getValue().get(0)));
        } else if (!this.surfaceProps.isEmpty() && !this.curveProps.isEmpty() || !this.surfaceProps.isEmpty() && !this.pointProps.isEmpty() || this.curveProps.size() > 1) {
            // empty if block
        }
        JoinQueryUtils.appendSpatialJoinQuery(this.reqEntity, "Intersects", joinProperties);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
    }

    public void selfJoinWithIntersects() {
        if (!ServiceMetadataUtils.implementsSpatialOperator(this.wfsMetadata, "Intersects")) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", "Intersects operator"));
        }
        if (!this.surfaceProps.isEmpty()) {
            // empty if block
        }
        if (!this.curveProps.isEmpty()) {
            // empty if block
        }
    }
}

