/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.querymgmt;

import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class StoredQueryManagement {
    public static final String LANG_WFS_QUERY = "urn:ogc:def:queryLanguage:OGC-WFS::WFSQueryExpression";
    public static final String MANAGE_STORED_QRY = "ManageStoredQueries";

    @BeforeTest
    public void implementsManageStoredQueries(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (!ServiceMetadataUtils.implementsConformanceClass(wfsMetadata, MANAGE_STORED_QRY)) {
            throw new SkipException(ErrorMessage.format("CapabilityNotImplemented", MANAGE_STORED_QRY));
        }
    }

    @Test(description="See OGC 09-025: Table 12, 14.2.2.5.3")
    public void supportedStoredQueryLanguages(ITestContext testContext) {
        Document wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        NodeList result = null;
        try {
            result = XMLUtils.evaluateXPath(wfsMetadata, "//ows:Operation[name='CreateStoredQuery']/ows:Parameter[@name='language']", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        Assert.assertTrue((result.getLength() > 0 ? 1 : 0) != 0, (String)"Missing 'language' parameter for CreateStoredQuery.");
        Assert.assertTrue((boolean)result.item(0).getTextContent().contains(LANG_WFS_QUERY), (String)ErrorMessage.format("QueryLangNotSupported", LANG_WFS_QUERY));
    }
}

