/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;

public final class FeatureProperty {
    private final QName name;
    private final QName featureType;
    private final QName valueType;
    private final XSElementDeclaration declaration;

    public FeatureProperty(QName featureType, XSElementDeclaration declaration) {
        this.featureType = featureType;
        this.declaration = declaration;
        this.name = new QName(declaration.getNamespace(), declaration.getName());
        this.valueType = this.getTypeName(declaration);
    }

    public QName getName() {
        return this.name;
    }

    public QName getFeatureType() {
        return this.featureType;
    }

    public QName getValueType() {
        return this.valueType;
    }

    public XSElementDeclaration getDeclaration() {
        return this.declaration;
    }

    QName getTypeName(XSElementDeclaration elementDecl) {
        XSTypeDefinition typeDef = elementDecl.getTypeDefinition();
        QName typeName = null;
        if (typeDef.getTypeCategory() == 16) {
            typeName = new QName(typeDef.getNamespace(), typeDef.getName());
        } else {
            XSComplexTypeDefinition complexTypeDef = (XSComplexTypeDefinition)typeDef;
            XSElementDeclaration elemDecl = (XSElementDeclaration)XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)complexTypeDef.getParticle()).get(0);
            typeName = new QName(elemDecl.getNamespace(), elemDecl.getName());
        }
        return typeName;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getFeatureType()).append('/');
        str.append(this.getName()).append('/');
        str.append(this.getValueType());
        return str.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.featureType == null ? 0 : this.featureType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureProperty other = (FeatureProperty)obj;
        if (this.featureType == null ? other.featureType != null : !this.featureType.equals(other.featureType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.valueType == null ? other.valueType != null : !this.valueType.equals(other.valueType));
    }
}

