/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.crs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.NilReferencingObject;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.crs.AbstractCRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.cs.AxisRangeType;
import org.geotoolkit.referencing.cs.DefaultCompoundCS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.CheckedContainer;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystem;

@Immutable
public class DefaultCompoundCRS
extends AbstractCRS
implements CompoundCRS {
    private static final long serialVersionUID = -2656710314586929287L;
    private final List<? extends CoordinateReferenceSystem> components;
    private transient List<SingleCRS> singles;
    private transient DefaultCompoundCRS[] shifted;

    private DefaultCompoundCRS() {
        this(NilReferencingObject.INSTANCE);
    }

    public DefaultCompoundCRS(CompoundCRS compoundCRS) {
        super(compoundCRS);
        if (compoundCRS instanceof DefaultCompoundCRS) {
            DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)compoundCRS;
            this.components = defaultCompoundCRS.components;
            this.singles = defaultCompoundCRS.singles;
        } else {
            this.components = this.copy(compoundCRS.getComponents());
        }
    }

    public DefaultCompoundCRS(String string, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        this(Collections.singletonMap("name", string), coordinateReferenceSystemArray);
    }

    public DefaultCompoundCRS(Map<String, ?> map, CoordinateReferenceSystem ... coordinateReferenceSystemArray) {
        super(map, DefaultCompoundCRS.createCoordinateSystem(coordinateReferenceSystemArray));
        this.components = this.copy(Arrays.asList(coordinateReferenceSystemArray));
    }

    private static CoordinateSystem createCoordinateSystem(CoordinateReferenceSystem[] coordinateReferenceSystemArray) {
        ArgumentChecks.ensureNonNull("components", coordinateReferenceSystemArray);
        if (coordinateReferenceSystemArray.length < 2) {
            throw new IllegalArgumentException(Errors.format(200, 2, coordinateReferenceSystemArray.length));
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[coordinateReferenceSystemArray.length];
        for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
            ArgumentChecks.ensureNonNull("crs", i, coordinateReferenceSystemArray);
            coordinateSystemArray[i] = coordinateReferenceSystemArray[i].getCoordinateSystem();
        }
        return new DefaultCompoundCS(coordinateSystemArray);
    }

    private List<? extends CoordinateReferenceSystem> copy(List<? extends CoordinateReferenceSystem> list) {
        list = this.computeSingleCRS(list) ? this.singles : UnmodifiableArrayList.wrap(list.toArray(new CoordinateReferenceSystem[list.size()]));
        return list;
    }

    public static DefaultCompoundCRS castOrCopy(CompoundCRS compoundCRS) {
        return compoundCRS == null || compoundCRS instanceof DefaultCompoundCRS ? (DefaultCompoundCRS)compoundCRS : new DefaultCompoundCRS(compoundCRS);
    }

    @Override
    public List<CoordinateReferenceSystem> getComponents() {
        return this.components;
    }

    public List<SingleCRS> getSingleCRS() {
        return this.singles;
    }

    public static List<SingleCRS> getSingleCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        List<SingleCRS> list;
        if (coordinateReferenceSystem instanceof DefaultCompoundCRS) {
            list = ((DefaultCompoundCRS)coordinateReferenceSystem).getSingleCRS();
        } else if (coordinateReferenceSystem instanceof CompoundCRS) {
            List<CoordinateReferenceSystem> list2 = ((CompoundCRS)coordinateReferenceSystem).getComponents();
            list = new ArrayList<SingleCRS>(list2.size());
            DefaultCompoundCRS.getSingleCRS(list2, list);
        } else {
            list = coordinateReferenceSystem instanceof SingleCRS ? Collections.singletonList((SingleCRS)coordinateReferenceSystem) : Collections.emptyList();
        }
        return list;
    }

    private static boolean getSingleCRS(List<? extends CoordinateReferenceSystem> list, List<SingleCRS> list2) {
        boolean bl = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : list) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                DefaultCompoundCRS.getSingleCRS(((CompoundCRS)coordinateReferenceSystem).getComponents(), list2);
                bl = false;
                continue;
            }
            list2.add((SingleCRS)coordinateReferenceSystem);
        }
        return bl;
    }

    private boolean computeSingleCRS(List<? extends CoordinateReferenceSystem> list) {
        this.singles = new ArrayList<SingleCRS>(list.size());
        boolean bl = DefaultCompoundCRS.getSingleCRS(list, this.singles);
        this.singles = UnmodifiableArrayList.wrap(this.singles.toArray(new SingleCRS[this.singles.size()]));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCompoundCRS shiftAxisRange(AxisRangeType axisRangeType) {
        DefaultCompoundCRS[] defaultCompoundCRSArray;
        DefaultCompoundCRS defaultCompoundCRS = this;
        synchronized (defaultCompoundCRS) {
            defaultCompoundCRSArray = this.shifted;
            if (defaultCompoundCRSArray == null) {
                this.shifted = defaultCompoundCRSArray = new DefaultCompoundCRS[2];
            }
        }
        int n = axisRangeType.ordinal();
        DefaultCompoundCRS[] defaultCompoundCRSArray2 = defaultCompoundCRSArray;
        synchronized (defaultCompoundCRSArray) {
            DefaultCompoundCRS defaultCompoundCRS2 = defaultCompoundCRSArray[n];
            if (defaultCompoundCRS2 == null) {
                boolean bl = false;
                CoordinateReferenceSystem[] coordinateReferenceSystemArray = this.components.toArray(new CoordinateReferenceSystem[this.components.size()]);
                for (int i = 0; i < coordinateReferenceSystemArray.length; ++i) {
                    CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[i];
                    if (!(coordinateReferenceSystem instanceof GeographicCRS)) continue;
                    coordinateReferenceSystemArray[i] = DefaultGeographicCRS.castOrCopy((GeographicCRS)coordinateReferenceSystem).shiftAxisRange(axisRangeType);
                    bl |= coordinateReferenceSystemArray[i] != coordinateReferenceSystem;
                }
                if (bl) {
                    defaultCompoundCRS2 = new DefaultCompoundCRS(IdentifiedObjects.getProperties(this, null), coordinateReferenceSystemArray);
                    defaultCompoundCRS2.shifted = defaultCompoundCRSArray;
                    defaultCompoundCRSArray[n ^ 1] = this;
                } else {
                    defaultCompoundCRS2 = this;
                }
                defaultCompoundCRSArray[n] = defaultCompoundCRS2;
            }
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return defaultCompoundCRS2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz;
        objectInputStream.defaultReadObject();
        if (this.components instanceof CheckedContainer && SingleCRS.class.isAssignableFrom(clazz = ((CheckedContainer)((Object)this.components)).getElementType())) {
            this.singles = this.components;
            return;
        }
        this.computeSingleCRS(this.components);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            switch (comparisonMode) {
                case STRICT: {
                    DefaultCompoundCRS defaultCompoundCRS = (DefaultCompoundCRS)object;
                    return Utilities.equals(this.components, defaultCompoundCRS.components);
                }
            }
            CompoundCRS compoundCRS = (CompoundCRS)object;
            return Utilities.deepEquals(this.getComponents(), compoundCRS.getComponents(), comparisonMode);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.components, super.computeHashCode());
    }

    @Override
    public String formatWKT(Formatter formatter) {
        for (CoordinateReferenceSystem coordinateReferenceSystem : this.components) {
            formatter.append(coordinateReferenceSystem);
        }
        return "COMPD_CS";
    }
}

