/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.web;

import javax.measure.unit.Unit;
import net.jcip.annotations.Immutable;
import org.geotoolkit.measure.Units;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Immutable
final class Code {
    private static final int MAXIMUM_FIELDS = 4;
    public final String authority;
    public final int code;
    public final Unit<?> unit;
    public final double longitude;
    public final double latitude;
    final Class<? extends CoordinateReferenceSystem> type;

    public Code(String string, Class<? extends CoordinateReferenceSystem> clazz, boolean bl) throws NoSuchAuthorityCodeException {
        String string2 = "AUTO";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n).trim();
        }
        int[] nArray = new int[5];
        int n2 = 0;
        do {
            if (n2 >= 4) {
                throw Code.noSuchAuthorityCode(clazz, string2, string, nArray);
            }
            nArray[n2++] = ++n;
        } while ((n = string.indexOf(44, n)) >= 0);
        nArray[n2] = string.length() + 1;
        switch (4 - n2) {
            case 0: {
                break;
            }
            case 1: {
                System.arraycopy(nArray, 1, nArray, 2, 3);
                break;
            }
            default: {
                if (!bl) break;
                throw Code.noSuchAuthorityCode(clazz, string2, string, nArray);
            }
        }
        int n3 = 0;
        int n4 = 9001;
        double d = Double.NaN;
        double d2 = Double.NaN;
        block13: for (int i = 0; i < 4; ++i) {
            String string3;
            int n5 = nArray[i + 1] - 1;
            n = nArray[i];
            if (n5 <= n || (string3 = string.substring(n, n5).trim()).isEmpty()) continue;
            try {
                switch (i) {
                    default: {
                        throw new AssertionError(i);
                    }
                    case 0: {
                        n3 = Integer.parseInt(string3);
                        continue block13;
                    }
                    case 1: {
                        n4 = Integer.parseInt(string3);
                        continue block13;
                    }
                    case 2: {
                        d = Double.parseDouble(string3);
                        continue block13;
                    }
                    case 3: {
                        d2 = Double.parseDouble(string3);
                        break;
                    }
                }
                break;
            }
            catch (NumberFormatException numberFormatException) {
                NoSuchAuthorityCodeException noSuchAuthorityCodeException = Code.noSuchAuthorityCode(clazz, string2, string, nArray);
                noSuchAuthorityCodeException.initCause(numberFormatException);
                throw noSuchAuthorityCodeException;
            }
        }
        if (!(!bl || d >= -180.0 && d <= 180.0 && d2 >= -90.0 && d2 <= 90.0)) {
            throw Code.noSuchAuthorityCode(clazz, string2, string, nArray);
        }
        this.authority = string2;
        this.code = n3;
        this.unit = Units.valueOfEPSG(n4);
        this.longitude = d;
        this.latitude = d2;
        this.type = clazz;
        if (this.unit == null) {
            throw new NoSuchAuthorityCodeException(Errors.format(227, n4), string2, string.substring(nArray[0]).trim(), string);
        }
    }

    private static NoSuchAuthorityCodeException noSuchAuthorityCode(Class<?> clazz, String string, String string2, int[] nArray) {
        String string3 = string2.substring(nArray[0]).trim();
        return new NoSuchAuthorityCodeException(Errors.format(165, string3, string, clazz), string, string3, string2);
    }

    public String toString() {
        return this.authority + ':' + this.code + ',' + this.longitude + ',' + this.latitude;
    }
}

