/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19136.SuiteAttribute;
import org.opengis.cite.iso19136.TestRunArg;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.URIUtils;
import org.opengis.cite.iso19136.util.ValidationUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteFixtureListener
implements ISuiteListener {
    @Override
    public void onStart(ISuite suite) {
        TestSuiteLogger.log(Level.CONFIG, String.format("[SuiteFixtureListener] All parameters:\n%s", suite.getXmlSuite().getAllParameters()));
        this.processIUTParameter(suite);
        this.processGmlReference(suite);
        this.processSchematronSchema(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        String reportDir = suite.getOutputDirectory();
        TestSuiteLogger.log(Level.CONFIG, String.format("Test run directory: %s", reportDir.substring(0, reportDir.lastIndexOf(File.separatorChar))));
    }

    void processIUTParameter(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String iutRef = params.get(TestRunArg.IUT.toString());
        if (null == iutRef || iutRef.isEmpty()) {
            return;
        }
        try {
            File iutFile = URIUtils.resolveURIAsFile(URI.create(iutRef));
            if (this.isXMLSchema(iutFile)) {
                params.put(TestRunArg.XSD.toString(), iutRef);
            } else {
                params.put(TestRunArg.GML.toString(), iutRef);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to read resource from " + iutRef, x);
        }
        params.remove(TestRunArg.IUT.toString());
    }

    void processGmlReference(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, String.format("Suite parameters:\n %s", params));
        HashSet<URI> schemaURIs = new HashSet<URI>();
        String xsdURI = params.get(TestRunArg.XSD.toString());
        if (null != xsdURI && !xsdURI.isEmpty()) {
            schemaURIs.add(URI.create(xsdURI));
            suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
            return;
        }
        String gmlURI = params.get(TestRunArg.GML.toString());
        if (null == gmlURI || gmlURI.isEmpty()) {
            throw new IllegalArgumentException("Missing GML resource (document or application schema).");
        }
        File gmlFile = null;
        try {
            gmlFile = URIUtils.resolveURIAsFile(URI.create(gmlURI));
            if (null == gmlFile || !gmlFile.exists()) {
                throw new IllegalArgumentException("Failed to dereference URI: " + gmlURI);
            }
            if (this.isXMLSchema(gmlFile)) {
                params.put(TestRunArg.XSD.toString(), gmlURI);
                schemaURIs.add(URI.create(gmlURI));
            } else {
                schemaURIs.addAll(ValidationUtils.extractSchemaReferences(new StreamSource(gmlFile), gmlURI));
                suite.setAttribute(SuiteAttribute.GML.getName(), gmlFile);
                TestSuiteLogger.log(Level.FINE, "Wrote GML document to " + gmlFile.getAbsolutePath());
            }
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to read resource obtained from " + gmlURI, iox);
        }
        catch (XMLStreamException xse) {
            throw new RuntimeException("Failed to find schema reference in source: " + gmlFile.getAbsolutePath(), xse);
        }
        suite.setAttribute(SuiteAttribute.SCHEMA_LOC_SET.getName(), schemaURIs);
        TestSuiteLogger.log(Level.FINE, String.format("Schema references: %s", schemaURIs));
    }

    void processSchematronSchema(ISuite suite) {
        Map<String, String> params = suite.getXmlSuite().getParameters();
        String schRef = params.get(TestRunArg.SCH.toString());
        if (schRef != null && !schRef.isEmpty()) {
            URI schURI = URI.create(params.get(TestRunArg.SCH.toString()));
            suite.setAttribute(SuiteAttribute.SCHEMATRON.getName(), schURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isXMLSchema(File file) {
        if (!file.exists() || file.length() == 0L) {
            return false;
        }
        QName docElemName = QName.valueOf("");
        FileInputStream inStream = null;
        XMLEventReader reader = null;
        try {
            inStream = new FileInputStream(file);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            reader = factory.createXMLEventReader(inStream);
            StartElement docElem = reader.nextTag().asStartElement();
            docElemName = docElem.getName();
        }
        catch (Exception e1) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                reader.close();
                ((InputStream)inStream).close();
            }
            catch (Exception e2) {
                TestSuiteLogger.log(Level.INFO, "Error closing resource.", e2);
            }
        }
        return docElemName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema");
    }
}

