/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.util.Arrays;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractDirectPosition
implements DirectPosition {
    protected AbstractDirectPosition() {
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this;
    }

    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        int n = this.getDimension();
        if (directPosition != null) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem2 != null && (coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(coordinateReferenceSystem2, coordinateReferenceSystem)) {
                throw new MismatchedReferenceSystemException(Errors.format(111));
            }
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, directPosition.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    @Override
    public double[] getCoordinate() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getOrdinate(i);
        }
        return dArray;
    }

    static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem coordinateReferenceSystem, int n) throws MismatchedDimensionException {
        int n2;
        if (coordinateReferenceSystem != null && (n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension()) != n) {
            throw new MismatchedDimensionException(Errors.format(113, coordinateReferenceSystem.getName().getCode(), n2, n));
        }
    }

    static void ensureDimensionMatch(String string, int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(113, string, n, n2));
        }
    }

    public String toString() {
        return AbstractDirectPosition.toString(this);
    }

    public static String toString(DirectPosition directPosition) {
        StringBuilder stringBuilder = new StringBuilder("POINT(");
        int n = directPosition.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            Strings.trimFractionalPart(stringBuilder.append(directPosition.getOrdinate(i)));
        }
        return stringBuilder.append(')').toString();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    static double[] parse(String string) throws NumberFormatException, IllegalArgumentException {
        char c;
        int n = string.length();
        int n2 = -1;
        do {
            if (++n2 >= n) {
                return null;
            }
            c = string.charAt(n2);
            if (!Character.isJavaIdentifierStart(c)) continue;
            do {
                if (++n2 < n) continue;
                return null;
            } while (Character.isJavaIdentifierPart(c = string.charAt(n2)));
        } while (Character.isWhitespace(c));
        char c2 = ' ';
        if (c == '(' || c == '[') {
            char c3;
            char c4 = c2 = c == '(' ? (char)')' : ']';
            do {
                if (++n2 >= n) {
                    c = ' ';
                    break;
                }
                c3 = string.charAt(n2);
                c = c3;
            } while (Character.isWhitespace(c3));
        }
        double[] dArray = new double[2];
        int n3 = 0;
        block3: while (true) {
            char c5;
            if (c == c2) {
                char c6;
                do {
                    if (++n2 >= n) return XArrays.resize(dArray, n3);
                    c6 = string.charAt(n2);
                    c = c6;
                } while (Character.isWhitespace(c6));
                throw new IllegalArgumentException(Errors.format(233, string, string.substring(n2)));
            }
            int n4 = n2;
            do {
                if (++n2 >= n) {
                    n2 = n;
                    c = ' ';
                    break;
                }
                c5 = string.charAt(n2);
                c = c5;
            } while (!Character.isWhitespace(c5) && c != c2);
            if (n3 == dArray.length) {
                dArray = Arrays.copyOf(dArray, n3 * 2);
            }
            dArray[n3++] = Double.parseDouble(string.substring(n4, n2));
            while (true) {
                if (!Character.isWhitespace(c)) continue block3;
                if (++n2 >= n) {
                    if (c2 == 32) return XArrays.resize(dArray, n3);
                    throw new IllegalArgumentException(Errors.format(132, string, Character.valueOf(c2)));
                }
                c = string.charAt(n2);
            }
            break;
        }
    }

    @Override
    public int hashCode() {
        return AbstractDirectPosition.hashCode(this);
    }

    static int hashCode(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            long l = Double.doubleToLongBits(directPosition.getOrdinate(i));
            n2 = 31 * n2 + ((int)l ^ (int)(l >>> 32));
        }
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            n2 += coordinateReferenceSystem.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DirectPosition) {
            DirectPosition directPosition = (DirectPosition)object;
            int n = this.getDimension();
            if (n == directPosition.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.equals(this.getOrdinate(i), directPosition.getOrdinate(i))) continue;
                    return false;
                }
                if (Utilities.equals(this.getCoordinateReferenceSystem(), directPosition.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == ((Object)directPosition).hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

