/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.io.Serializable;
import org.geotoolkit.util.Cloneable;

public final class Complex
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8143196508298758583L;
    public double real;
    public double imag;

    public Complex() {
    }

    public Complex(Complex complex) {
        this.real = complex.real;
        this.imag = complex.imag;
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public void copy(Complex complex) {
        this.real = complex.real;
        this.imag = complex.imag;
    }

    public void multiply(Complex complex, double d) {
        this.real = complex.real * d;
        this.imag = complex.imag * d;
    }

    public void multiply(Complex complex, Complex complex2) {
        double d = complex.real;
        double d2 = complex.imag;
        double d3 = complex2.real;
        double d4 = complex2.imag;
        this.real = d * d3 - d2 * d4;
        this.imag = d2 * d3 + d * d4;
    }

    public void divide(Complex complex, Complex complex2) {
        double d = complex.real;
        double d2 = complex.imag;
        double d3 = complex2.real;
        double d4 = complex2.imag;
        double d5 = d3 * d3 + d4 * d4;
        this.real = (d * d3 + d2 * d4) / d5;
        this.imag = (d2 * d3 - d * d4) / d5;
    }

    public void add(Complex complex, Complex complex2) {
        this.real = complex.real + complex2.real;
        this.imag = complex.imag + complex2.imag;
    }

    public void addMultiply(Complex complex, Complex complex2, Complex complex3) {
        double d = complex2.real;
        double d2 = complex2.imag;
        double d3 = complex3.real;
        double d4 = complex3.imag;
        this.real = complex.real + (d * d3 - d2 * d4);
        this.imag = complex.imag + (d2 * d3 + d * d4);
    }

    public void power(Complex complex, int n) {
        double d = complex.real;
        double d2 = complex.imag;
        switch (n) {
            case 0: {
                this.real = 1.0;
                this.imag = 0.0;
                break;
            }
            case 1: {
                this.real = d;
                this.imag = d2;
                break;
            }
            case 2: {
                this.real = d * d - d2 * d2;
                this.imag = 2.0 * d * d2;
                break;
            }
            case 3: {
                double d3 = d * d;
                double d4 = d2 * d2;
                this.real = d * (d3 - 3.0 * d4);
                this.imag = d2 * (3.0 * d3 - d4);
                break;
            }
            case 4: {
                double d5 = d * d;
                double d6 = d2 * d2;
                this.real = d5 * d5 - 6.0 * d5 * d6 + d6 * d6;
                this.imag = 4.0 * (d * d2) * (d5 - d6);
                break;
            }
            case 5: {
                double d7 = d * d;
                double d8 = d2 * d2;
                double d9 = d7 * d7;
                double d10 = d8 * d8;
                double d11 = d7 * d8 * 10.0;
                this.real = d * (d9 - d11 + 5.0 * d10);
                this.imag = d2 * (5.0 * d9 - d11 + d10);
                break;
            }
            case 6: {
                double d12 = d * d;
                double d13 = d2 * d2;
                double d14 = d12 * d12;
                double d15 = d13 * d13;
                this.real = d14 * (d12 - 15.0 * d13) + 15.0 * d12 * d15 - d15 * d13;
                this.imag = d * d2 * (6.0 * (d14 + d15) - 20.0 * d12 * d13);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
    }

    @Override
    public Complex clone() {
        return new Complex(this);
    }

    public boolean equals(Complex complex) {
        return Double.doubleToLongBits(this.real) == Double.doubleToLongBits(complex.real) && Double.doubleToLongBits(this.imag) == Double.doubleToLongBits(complex.imag);
    }

    public boolean equals(Object object) {
        return object instanceof Complex && this.equals((Complex)object);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.real) + 31L * Double.doubleToLongBits(this.imag);
        return (int)l ^ (int)(l >>> 32);
    }

    public String toString() {
        return "Complex[" + this.real + ", " + this.imag + ']';
    }
}

