/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation;

import java.awt.geom.AffineTransform;
import org.geotoolkit.internal.referencing.DirectPositionView;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.operation.matrix.Matrices;
import org.geotoolkit.referencing.operation.matrix.XMatrix;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.ConcatenatedTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.referencing.operation.transform.ProjectiveTransform;
import org.geotoolkit.util.ArgumentChecks;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public final class MathTransforms
extends Static {
    private MathTransforms() {
    }

    public static LinearTransform identity(int n) {
        ArgumentChecks.ensureStrictlyPositive("dimension", n);
        return ProjectiveTransform.identity(n);
    }

    public static LinearTransform linear(int n, double d, double d2) {
        ArgumentChecks.ensureStrictlyPositive("dimension", n);
        if (d2 == 0.0 && d == 1.0) {
            return MathTransforms.identity(n);
        }
        if (n == 1) {
            return LinearTransform1D.create(d, d2);
        }
        XMatrix xMatrix = Matrices.create(n + 1);
        for (int i = 0; i < n; ++i) {
            xMatrix.setElement(i, i, d);
            xMatrix.setElement(i, n, d2);
        }
        return MathTransforms.linear(xMatrix);
    }

    public static LinearTransform linear(Matrix matrix) {
        ArgumentChecks.ensureNonNull("matrix", matrix);
        return ProjectiveTransform.create(matrix);
    }

    public static LinearTransform linear(AffineTransform affineTransform) {
        ArgumentChecks.ensureNonNull("matrix", affineTransform);
        if (affineTransform instanceof AffineTransform2D) {
            return (AffineTransform2D)affineTransform;
        }
        return affineTransform.isIdentity() ? MathTransforms.identity(2) : new AffineTransform2D(affineTransform);
    }

    public static LinearTransform dimensionFilter(int n, int[] nArray) throws IndexOutOfBoundsException {
        return MathTransforms.linear(Matrices.createDimensionFilter(n, nArray));
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2) {
        ArgumentChecks.ensureNonNull("tr1", mathTransform);
        ArgumentChecks.ensureNonNull("tr2", mathTransform2);
        return ConcatenatedTransform.create(mathTransform, mathTransform2);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2) {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2);
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2) {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2);
    }

    public static MathTransform concatenate(MathTransform mathTransform, MathTransform mathTransform2, MathTransform mathTransform3) {
        ArgumentChecks.ensureNonNull("tr1", mathTransform);
        ArgumentChecks.ensureNonNull("tr2", mathTransform2);
        ArgumentChecks.ensureNonNull("tr3", mathTransform3);
        return MathTransforms.concatenate(MathTransforms.concatenate(mathTransform, mathTransform2), mathTransform3);
    }

    public static MathTransform2D concatenate(MathTransform2D mathTransform2D, MathTransform2D mathTransform2D2, MathTransform2D mathTransform2D3) {
        return (MathTransform2D)MathTransforms.concatenate((MathTransform)mathTransform2D, (MathTransform)mathTransform2D2, (MathTransform)mathTransform2D3);
    }

    public static MathTransform1D concatenate(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2, MathTransform1D mathTransform1D3) {
        return (MathTransform1D)MathTransforms.concatenate((MathTransform)mathTransform1D, (MathTransform)mathTransform1D2, (MathTransform)mathTransform1D3);
    }

    public static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, int n, double[] dArray2, int n2) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, n, dArray2, n2, true);
        }
        Matrix matrix = mathTransform.derivative(new DirectPositionView(dArray, n, mathTransform.getSourceDimensions()));
        if (dArray2 != null) {
            mathTransform.transform(dArray, n, dArray2, n2, 1);
        }
        return matrix;
    }
}

