/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

public final class XInteger {
    private static final int RADIX = 10;
    private static final int UNSIGNED_LIMIT = -2147483647;
    private static final int UNSIGNED_MULMIN = -214748364;

    private XInteger() {
    }

    public static int parseIntSigned(CharSequence str, int i, int max) throws NumberFormatException {
        if (str == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        if (max > 0) {
            int digit;
            int limit;
            if (str.charAt(i) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = Character.digit(str.charAt(i++), 10)) < 0) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(str.charAt(i++), 10)) < 0) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                if (result < multmin) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
        }
        return -result;
    }

    public static int parseIntUnsigned(CharSequence str, int i, int max) throws NumberFormatException {
        if (str == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        if (i < max) {
            int digit;
            if ((digit = Character.digit(str.charAt(i++), 10)) < 0) {
                throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
            }
            result = -digit;
            while (i < max) {
                if ((digit = Character.digit(str.charAt(i++), 10)) < 0) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                if (result < -214748364) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                if ((result *= 10) < -2147483647 + digit) {
                    throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("Unvalid integer string :" + str.subSequence(i, max));
        }
        return -result;
    }
}

