/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.locking;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.locking.LockingFixture;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.WFSMessage;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LockFeatureTests
extends LockingFixture {
    private static Random randomIndex = new Random(System.currentTimeMillis());

    @BeforeMethod
    public void buildSimpleLockFeatureRequest() {
        this.reqEntity = WFSMessage.createRequestEntity("LockFeature", this.wfsVersion);
    }

    @Test(description="See ISO 19142: 12.2.4.3, 15.2.3.1.2")
    public void lockFeatureAndAttemptDelete() {
        QName featureType = this.dataSampler.selectRandomFeatureType();
        String gmlId = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 1).iterator().next();
        WFSMessage.appendStoredQuery(this.reqEntity, this.storedQueryId, Collections.singletonMap("id", gmlId));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "60");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertXPath("//wfs:LockFeatureResponse", this.rspEntity, null);
        Element lockRsp = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "LockFeatureResponse").item(0);
        String lockId = lockRsp.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId"));
        this.locks.add(lockId);
        String xpath = String.format("//wfs:FeaturesLocked/fes:ResourceId/@rid = '%s'", gmlId);
        ETSAssert.assertXPath(xpath, lockRsp, null);
        HashMap<String, QName> idTofeatureType = new HashMap<String, QName>();
        idTofeatureType.put(gmlId, featureType);
        Document trxResponse = this.wfsClient.deleteFeatures(idTofeatureType, ProtocolBinding.ANY);
        String xpath2 = "//ows:Exception[@exceptionCode = 'MissingParameterValue']";
        ETSAssert.assertXPath(xpath2, trxResponse.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 12.2.3, 12.2.5")
    public void lockFeatureAlreadyLocked() {
        QName featureType = this.dataSampler.selectRandomFeatureType();
        String gmlId = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 1).iterator().next();
        WFSMessage.appendStoredQuery(this.reqEntity, this.storedQueryId, Collections.singletonMap("id", gmlId));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "60");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element lockRsp = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "LockFeatureResponse").item(0);
        this.locks.add(lockRsp.getAttribute("lockId"));
        this.reqEntity.getDocumentElement().setAttribute("expiry", "180");
        rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'CannotLockAllFeatures']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 12.3.2", dataProvider="protocol-featureType")
    public void lockAllFeaturesByType(ProtocolBinding binding, QName featureType) {
        if (!((FeatureTypeInfo)this.featureInfo.get(featureType)).isInstantiated()) {
            throw new SkipException("No data available for feature type " + featureType);
        }
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "LockFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element lockRsp = this.rspEntity.getDocumentElement();
        Assert.assertEquals((String)lockRsp.getLocalName(), (String)"LockFeatureResponse", (String)ErrorMessage.get("LocalName"));
        String lockId = lockRsp.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId in " + lockRsp.getNodeName()));
        this.locks.add(lockId);
        ETSAssert.assertXPath("//wfs:FeaturesLocked", lockRsp, null);
        ETSAssert.assertXPath("not(//wfs:FeaturesNotLocked)", lockRsp, null);
    }

    @Test(description="See 09-025r2: 12.2.4.2")
    public void lockFeatureWithLockIdAndQuery() {
        if (!"2.0.2".equals(this.wfsVersion)) {
            throw new SkipException("Tested only for WFS 2.0.2");
        }
        QName featureType = this.dataSampler.selectRandomFeatureType();
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        this.reqEntity.getDocumentElement().setAttribute("expiry", "10");
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Element featureColl = (Element)this.rspEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureCollection").item(0);
        String lockId = featureColl.getAttribute("lockId");
        Assert.assertFalse((boolean)lockId.isEmpty(), (String)ErrorMessage.format("MissingInfosetItem", "@lockId"));
        this.locks.add(lockId);
        this.reqEntity = WFSMessage.createRequestEntity("LockFeature", this.wfsVersion);
        this.reqEntity.getDocumentElement().setAttribute("lockId", lockId);
        WFSMessage.appendSimpleQuery(this.reqEntity, featureType);
        rsp = this.wfsClient.submitRequest(this.reqEntity, ProtocolBinding.ANY);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'OperationParsingFailed']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }
}

