/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TimeUtils {
    private static final DocumentBuilder DOC_BUILDER = TimeUtils.initDocBuilder();

    private static DocumentBuilder initDocBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            TestSuiteLogger.log(Level.WARNING, "TimeUtils: Failed to create DocumentBuilder", e);
        }
        return builder;
    }

    public static Document intervalAsGML(ZonedDateTime startDateTime, ZonedDateTime endDateTime) {
        Document gmlTimePeriod;
        try {
            gmlTimePeriod = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimePeriod.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        String beginPosition = startDateTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "beginPosition").item(0).setTextContent(beginPosition);
        String endPosition = endDateTime.format(DateTimeFormatter.ISO_INSTANT);
        gmlTimePeriod.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "endPosition").item(0).setTextContent(endPosition);
        return gmlTimePeriod;
    }

    public static Document periodAsGML(Period period) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        String startOfPeriod = period.getBeginning().getPosition().getDateTime().toString();
        ZonedDateTime startDateTime = ZonedDateTime.parse(startOfPeriod, dateTimeFormatter);
        String endOfPeriod = period.getEnding().getPosition().getDateTime().toString();
        ZonedDateTime endDateTime = ZonedDateTime.parse(endOfPeriod, dateTimeFormatter);
        return TimeUtils.intervalAsGML(startDateTime, endDateTime);
    }

    public static Document instantAsGML(Instant instant, ZoneOffset offset) {
        Document gmlTimeInstant;
        if (null == offset) {
            offset = ZoneOffset.UTC;
        }
        try {
            gmlTimeInstant = DOC_BUILDER.parse(TimeUtils.class.getResourceAsStream("TimeInstant.xml"));
        }
        catch (IOException | SAXException e) {
            return null;
        }
        OffsetDateTime tPos = instant.getPosition().getDate().toInstant().atOffset(offset);
        String timePositionValue = tPos.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Node timePosition = gmlTimeInstant.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "timePosition").item(0);
        timePosition.setTextContent(timePositionValue);
        return gmlTimeInstant;
    }
}

