/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.FactoryRegistryException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.util.ArgumentChecks;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class TransformedDirectPosition
extends GeneralDirectPosition {
    private static final long serialVersionUID = -3988283183934950437L;
    private final CoordinateOperationFactory factory;
    private final CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem sourceCRS;
    private transient MathTransform forward;
    private transient MathTransform inverse;

    public TransformedDirectPosition() {
        this(null, DefaultGeographicCRS.WGS84, null);
    }

    public TransformedDirectPosition(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Hints hints) throws FactoryRegistryException {
        super(coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)coordinateReferenceSystem2);
        this.defaultCRS = CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2) ? null : coordinateReferenceSystem;
        this.factory = FactoryFinder.getCoordinateOperationFactory((Hints)hints);
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"crs", (Object)coordinateReferenceSystem);
        super.setCoordinateReferenceSystem(coordinateReferenceSystem);
        this.forward = null;
        this.inverse = null;
    }

    private void setSourceCRS(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateOperation coordinateOperation;
        CoordinateReferenceSystem coordinateReferenceSystem2 = this.getCoordinateReferenceSystem();
        try {
            coordinateOperation = this.factory.createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getLocalizedMessage(), factoryException);
        }
        this.forward = coordinateOperation.getMathTransform();
        this.inverse = null;
        this.sourceCRS = coordinateReferenceSystem;
    }

    public void transform(DirectPosition directPosition) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null && (coordinateReferenceSystem = this.defaultCRS) == null) {
            this.setLocation(directPosition);
            return;
        }
        if (this.forward == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, coordinateReferenceSystem)) {
            this.setSourceCRS(coordinateReferenceSystem);
        }
        if (this.forward.transform(directPosition, this) != this) {
            throw new AssertionError(this.forward);
        }
    }

    public DirectPosition inverseTransform(CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        if (this.inverse == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, coordinateReferenceSystem)) {
            ArgumentChecks.ensureNonNull((String)"crs", (Object)coordinateReferenceSystem);
            this.setSourceCRS(coordinateReferenceSystem);
            this.inverse = this.forward.inverse();
        }
        return this.inverse.transform(this, null);
    }

    public DirectPosition inverseTransform() throws TransformException {
        if (this.defaultCRS != null) {
            return this.inverseTransform(this.defaultCRS);
        }
        return new GeneralDirectPosition(this);
    }
}

