/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.geotoolkit.internal.Citations;
import org.geotoolkit.io.X364;
import org.geotoolkit.util.Strings;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class ParameterTableRow {
    private Object value;
    private boolean asList;
    int width;
    private final Map<String, Set<Object>> identifiers;

    ParameterTableRow(IdentifiedObject identifiedObject, Locale locale, Object object, boolean bl) {
        this.value = object;
        this.identifiers = new LinkedHashMap<String, Set<Object>>();
        ReferenceIdentifier referenceIdentifier = identifiedObject.getName();
        this.addIdentifier(this.getAuthority(referenceIdentifier), referenceIdentifier.getCode());
        if (!bl) {
            Object object2;
            Object object3;
            Object object4;
            Collection<GenericName> collection = identifiedObject.getAlias();
            if (collection != null) {
                object4 = collection.iterator();
                while (object4.hasNext()) {
                    object3 = (GenericName)object4.next();
                    object2 = null;
                    if (object3 instanceof Identifier) {
                        object2 = this.getAuthority((Identifier)object3);
                    }
                    this.addIdentifier((String)object2, object3.tip().toInternationalString().toString(locale));
                }
            }
            if ((object4 = identifiedObject.getIdentifiers()) != null) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (Identifier)object3.next();
                    this.addIdentifier(this.getAuthority((Identifier)object2), object2);
                }
            }
        }
    }

    private String getAuthority(Identifier identifier) {
        int n;
        String string = Citations.getIdentifier((Citation)identifier.getAuthority());
        if (string != null && (n = string.length()) > this.width) {
            this.width = n;
        }
        return string;
    }

    private void addIdentifier(String string, Object object) {
        Set<Object> set = this.identifiers.get(string);
        if (set == null) {
            set = new LinkedHashSet<Object>(8);
            this.identifiers.put(string, set);
        }
        set.add(object);
    }

    final void addValue(Object object) {
        ArrayList<Object> arrayList;
        if (!this.asList) {
            this.asList = true;
            arrayList = new ArrayList<Object>(4);
            arrayList.add(this.value);
            this.value = arrayList;
        } else {
            arrayList = (ArrayList<Object>)this.value;
        }
        arrayList.add(object);
    }

    final Object values(Object[] objectArray) {
        Object[] objectArray2 = this.value;
        if (objectArray2 instanceof Collection) {
            objectArray2 = ((Collection)objectArray2).toArray();
        } else if (objectArray2 == null || !objectArray2.getClass().isArray()) {
            objectArray[0] = objectArray2;
            objectArray2 = objectArray;
        }
        return objectArray2;
    }

    private static void write(Writer writer, X364 x364, boolean bl) throws IOException {
        if (bl) {
            writer.write(x364.sequence());
        }
    }

    final void write(Writer writer, boolean bl, boolean bl2, String string) throws IOException {
        boolean bl3 = false;
        for (Map.Entry<String, Set<Object>> entry : this.identifiers.entrySet()) {
            if (bl3) {
                writer.write(string);
            }
            bl3 = true;
            int n = this.width + 1;
            String string2 = entry.getKey();
            ParameterTableRow.write(writer, X364.FOREGROUND_GREEN, bl);
            if (string2 != null) {
                ParameterTableRow.write(writer, X364.FAINT, bl2);
                writer.write(string2);
                writer.write(58);
                ParameterTableRow.write(writer, X364.NORMAL, bl2);
                n -= string2.length();
            }
            writer.write(Strings.spaces((int)n));
            ParameterTableRow.write(writer, X364.BOLD, bl);
            Iterator<Object> iterator = entry.getValue().iterator();
            writer.write(ParameterTableRow.toString(iterator.next()));
            ParameterTableRow.write(writer, X364.RESET, bl);
            boolean bl4 = false;
            while (iterator.hasNext()) {
                X364 x364;
                X364 x3642;
                writer.write(bl4 ? ", " : " (");
                Object object = iterator.next();
                if (object instanceof Identifier) {
                    x3642 = X364.FOREGROUND_YELLOW;
                    x364 = X364.FOREGROUND_DEFAULT;
                } else {
                    x3642 = X364.FAINT;
                    x364 = X364.NORMAL;
                }
                ParameterTableRow.write(writer, x3642, bl);
                writer.write(ParameterTableRow.toString(object));
                ParameterTableRow.write(writer, x364, bl);
                bl4 = true;
            }
            if (bl4) {
                writer.write(41);
            }
            ParameterTableRow.write(writer, X364.RESET, bl);
        }
    }

    private static String toString(Object object) {
        if (object instanceof Identifier) {
            object = ((Identifier)object).getCode();
        }
        return object.toString();
    }
}

