/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.io.wkt.Formatter;
import org.geotoolkit.measure.Units;
import org.geotoolkit.referencing.AbstractIdentifiedObject;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.DirectionAlongMeridian;
import org.geotoolkit.referencing.cs.Directions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.util.InternationalString;

@Immutable
public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    static final int COMPASS_DIRECTION_COUNT = 16;
    private static int PREDEFINED_COUNT = 0;
    private static final DefaultCoordinateSystemAxis[] PREDEFINED = new DefaultCoordinateSystemAxis[27];
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(124, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(123, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LONGITUDE = new DefaultCoordinateSystemAxis(184, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LATITUDE = new DefaultCoordinateSystemAxis(170, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(92, "h", AxisDirection.UP, (Unit<?>)SI.METRE);
    public static final DefaultCoordinateSystemAxis GRAVITY_RELATED_HEIGHT = new DefaultCoordinateSystemAxis(132, "H", AxisDirection.UP, (Unit<?>)SI.METRE);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(9, "h", AxisDirection.UP, (Unit<?>)SI.METRE);
    public static final DefaultCoordinateSystemAxis DEPTH;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE;
    public static final DefaultCoordinateSystemAxis X;
    public static final DefaultCoordinateSystemAxis Y;
    public static final DefaultCoordinateSystemAxis Z;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z;
    public static final DefaultCoordinateSystemAxis EASTING;
    public static final DefaultCoordinateSystemAxis WESTING;
    public static final DefaultCoordinateSystemAxis NORTHING;
    public static final DefaultCoordinateSystemAxis SOUTHING;
    public static final DefaultCoordinateSystemAxis TIME;
    public static final DefaultCoordinateSystemAxis COLUMN;
    public static final DefaultCoordinateSystemAxis ROW;
    public static final DefaultCoordinateSystemAxis DISPLAY_X;
    public static final DefaultCoordinateSystemAxis DISPLAY_Y;
    public static final DefaultCoordinateSystemAxis UNDEFINED;
    private static final DefaultCoordinateSystemAxis UNITIALIZED;
    private static final Map<String, CoordinateSystemAxis> ALIASES;
    @XmlElement(name="axisAbbrev", required=true)
    private final String abbreviation;
    @XmlElement(name="axisDirection", required=true)
    private final AxisDirection direction;
    @XmlAttribute(name="uom", required=true)
    private final Unit<?> unit;
    private final double minimum;
    private final double maximum;
    private final RangeMeaning rangeMeaning;
    private transient DefaultCoordinateSystemAxis opposite;

    private static boolean nameMatchesXY(String string, String string2) {
        if ((string = string.trim()).length() == 1) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis;
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'x': {
                    defaultCoordinateSystemAxis = EASTING;
                    break;
                }
                case 'y': {
                    defaultCoordinateSystemAxis = NORTHING;
                    break;
                }
                default: {
                    return false;
                }
            }
            return defaultCoordinateSystemAxis.nameMatches(string2) || defaultCoordinateSystemAxis.getOpposite().nameMatches(string2);
        }
        return false;
    }

    private DefaultCoordinateSystemAxis() {
        this(UNITIALIZED);
    }

    public DefaultCoordinateSystemAxis(CoordinateSystemAxis coordinateSystemAxis) {
        super(coordinateSystemAxis);
        this.abbreviation = coordinateSystemAxis.getAbbreviation();
        this.direction = coordinateSystemAxis.getDirection();
        this.unit = coordinateSystemAxis.getUnit();
        this.minimum = coordinateSystemAxis.getMinimumValue();
        this.maximum = coordinateSystemAxis.getMaximumValue();
        this.rangeMeaning = coordinateSystemAxis.getRangeMeaning();
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit, double d, double d2, RangeMeaning rangeMeaning) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        this.minimum = d;
        this.maximum = d2;
        this.rangeMeaning = rangeMeaning;
        ArgumentChecks.ensureNonNull((String)"abbreviation", (Object)string);
        ArgumentChecks.ensureNonNull((String)"direction", (Object)axisDirection);
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ArgumentChecks.ensureNonNull((String)"rangeMeaning", (Object)rangeMeaning);
        if (!(d < d2)) {
            throw new IllegalArgumentException(Errors.format((int)14, (Object)d, (Object)d2));
        }
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        ArgumentChecks.ensureNonNull((String)"abbreviation", (Object)string);
        ArgumentChecks.ensureNonNull((String)"direction", (Object)axisDirection);
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        if (Units.isAngular(unit)) {
            UnitConverter unitConverter = NonSI.DEGREE_ANGLE.getConverterTo(unit.asType(Angle.class));
            AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
            if (axisDirection2.equals(AxisDirection.NORTH)) {
                double d = Math.abs(unitConverter.convert(90.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.EXACT;
                return;
            }
            if (axisDirection2.equals(AxisDirection.EAST)) {
                double d = Math.abs(unitConverter.convert(180.0));
                this.minimum = -d;
                this.maximum = d;
                this.rangeMeaning = RangeMeaning.WRAPAROUND;
                return;
            }
        }
        this.minimum = Double.NEGATIVE_INFINITY;
        this.maximum = Double.POSITIVE_INFINITY;
        this.rangeMeaning = RangeMeaning.EXACT;
    }

    public DefaultCoordinateSystemAxis(String string, AxisDirection axisDirection, Unit<?> unit) {
        this(Collections.singletonMap("name", string), string, axisDirection, unit);
    }

    public DefaultCoordinateSystemAxis(CharSequence charSequence, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(DefaultCoordinateSystemAxis.toMap(charSequence), string, axisDirection, unit);
    }

    private static Map<String, Object> toMap(CharSequence charSequence) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        if (charSequence != null) {
            if (charSequence instanceof InternationalString) {
                hashMap.put("name", ((InternationalString)charSequence).toString(null));
                hashMap.put("alias", charSequence);
            } else {
                hashMap.put("name", ((Object)charSequence).toString());
            }
        }
        return hashMap;
    }

    private DefaultCoordinateSystemAxis(int n, String string, AxisDirection axisDirection, Unit<?> unit) {
        this(n >= 0 ? Vocabulary.formatInternational((int)n) : string, string, axisDirection, unit);
        DefaultCoordinateSystemAxis.PREDEFINED[DefaultCoordinateSystemAxis.PREDEFINED_COUNT++] = this;
    }

    public static DefaultCoordinateSystemAxis castOrCopy(CoordinateSystemAxis coordinateSystemAxis) {
        return coordinateSystemAxis == null || coordinateSystemAxis instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)coordinateSystemAxis : new DefaultCoordinateSystemAxis(coordinateSystemAxis);
    }

    public static DefaultCoordinateSystemAxis getPredefined(String string, AxisDirection axisDirection) {
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = null;
        for (int i = 0; i < PREDEFINED_COUNT; ++i) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis2 = PREDEFINED[i];
            if (axisDirection != null && !axisDirection.equals(defaultCoordinateSystemAxis2.getDirection())) continue;
            if (defaultCoordinateSystemAxis2.abbreviation.equals(string)) {
                return defaultCoordinateSystemAxis2;
            }
            if (defaultCoordinateSystemAxis != null || !defaultCoordinateSystemAxis2.nameMatches(string) || (defaultCoordinateSystemAxis2 == GEODETIC_LONGITUDE || defaultCoordinateSystemAxis2 == GEODETIC_LATITUDE) && !string.toLowerCase().startsWith("geodetic")) continue;
            defaultCoordinateSystemAxis = defaultCoordinateSystemAxis2;
        }
        if (defaultCoordinateSystemAxis == null && string.length() == 1) {
            switch (string.charAt(0)) {
                case 'X': {
                    if (!AxisDirection.OTHER.equals(axisDirection)) break;
                    return GEOCENTRIC_X;
                }
                case 'Y': {
                    if (!AxisDirection.EAST.equals(axisDirection)) break;
                    return GEOCENTRIC_Y;
                }
                case 'Z': {
                    if (!AxisDirection.NORTH.equals(axisDirection)) break;
                    return GEOCENTRIC_Z;
                }
            }
        }
        return defaultCoordinateSystemAxis;
    }

    static DefaultCoordinateSystemAxis getPredefined(CoordinateSystemAxis coordinateSystemAxis) {
        return DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis.getName().getCode(), coordinateSystemAxis.getDirection());
    }

    static DefaultCoordinateSystemAxis[] values() {
        return (DefaultCoordinateSystemAxis[])PREDEFINED.clone();
    }

    public static AxisDirection getDirection(String string) throws NoSuchElementException {
        ArgumentChecks.ensureNonNull((String)"direction", (Object)string);
        string = string.trim();
        AxisDirection axisDirection = Directions.find(string);
        if (axisDirection != null) {
            return axisDirection;
        }
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(string);
        if (directionAlongMeridian != null) {
            axisDirection = directionAlongMeridian.getDirection();
            assert (axisDirection == Directions.find(directionAlongMeridian.toString()));
            return axisDirection;
        }
        throw new NoSuchElementException(Errors.format((int)217, (Object)string));
    }

    @Override
    public AxisDirection getDirection() {
        return this.direction;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double getMinimumValue() {
        return this.minimum;
    }

    @Override
    public double getMaximumValue() {
        return this.maximum;
    }

    @Override
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    final DefaultCoordinateSystemAxis getOpposite() {
        return this.opposite;
    }

    public static boolean isCompassDirection(AxisDirection axisDirection) {
        ArgumentChecks.ensureNonNull((String)"direction", (Object)axisDirection);
        int n = axisDirection.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static double getAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        DirectionAlongMeridian directionAlongMeridian;
        ArgumentChecks.ensureNonNull((String)"source", (Object)axisDirection);
        ArgumentChecks.ensureNonNull((String)"target", (Object)axisDirection2);
        int n = DefaultCoordinateSystemAxis.getCompassAngle(axisDirection, axisDirection2);
        if (n != Integer.MIN_VALUE) {
            return (double)n * 22.5;
        }
        DirectionAlongMeridian directionAlongMeridian2 = DirectionAlongMeridian.parse(axisDirection);
        if (directionAlongMeridian2 != null && (directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection2)) != null) {
            return directionAlongMeridian2.getAngle(directionAlongMeridian);
        }
        return Double.NaN;
    }

    static int getCompassAngle(AxisDirection axisDirection, AxisDirection axisDirection2) {
        int n;
        int n2 = AxisDirection.NORTH.ordinal();
        int n3 = axisDirection.ordinal() - n2;
        if (n3 >= 0 && n3 < 16 && (n = axisDirection2.ordinal() - n2) >= 0 && n < 16) {
            if ((n = n3 - n) < -8) {
                n += 16;
            } else if (n > 8) {
                n -= 16;
            }
            return n;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean perpendicular(AxisDirection axisDirection, AxisDirection axisDirection2) {
        return Math.abs(Math.abs(DefaultCoordinateSystemAxis.getAngle(axisDirection, axisDirection2)) - 90.0) <= 1.0E-10;
    }

    final DefaultCoordinateSystemAxis usingUnit(Unit<?> unit) throws ConversionException {
        if (this.unit.equals(unit)) {
            return this;
        }
        UnitConverter unitConverter = this.unit.getConverterToAny(unit);
        return new DefaultCoordinateSystemAxis(IdentifiedObjects.getProperties(this, null), this.abbreviation, this.direction, unit, unitConverter.convert(this.minimum), unitConverter.convert(this.maximum), this.rangeMeaning);
    }

    @Override
    public boolean nameMatches(String string) {
        if (super.nameMatches(string)) {
            return true;
        }
        CoordinateSystemAxis coordinateSystemAxis = ALIASES.get(string.trim().toLowerCase());
        return coordinateSystemAxis != null && coordinateSystemAxis == ALIASES.get(this.getName().getCode().trim().toLowerCase());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.castOrCopy((CoordinateSystemAxis)object);
            return this.equals(defaultCoordinateSystemAxis, comparisonMode.ordinal() < ComparisonMode.IGNORE_METADATA.ordinal(), true);
        }
        return false;
    }

    final boolean equals(DefaultCoordinateSystemAxis defaultCoordinateSystemAxis, boolean bl, boolean bl2) {
        if (bl) {
            if (!Utilities.equals((Object)this.abbreviation, (Object)defaultCoordinateSystemAxis.abbreviation) || !Utilities.equals((Object)this.rangeMeaning, (Object)defaultCoordinateSystemAxis.rangeMeaning) || Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.minimum) || Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(defaultCoordinateSystemAxis.maximum)) {
                return false;
            }
        } else {
            String string;
            String string2 = defaultCoordinateSystemAxis.getName().getCode();
            if (!this.nameMatches(string2) && !IdentifiedObjects.nameMatches((IdentifiedObject)defaultCoordinateSystemAxis, string = this.getName().getCode())) {
                if (!bl2) {
                    return false;
                }
                if (!DefaultCoordinateSystemAxis.nameMatchesXY(string2, string) && !DefaultCoordinateSystemAxis.nameMatchesXY(string, string2)) {
                    return false;
                }
            }
        }
        return Utilities.equals((Object)this.direction, (Object)defaultCoordinateSystemAxis.direction) && (!bl2 || Utilities.equals(this.unit, defaultCoordinateSystemAxis.unit));
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash(this.unit, (int)Utilities.hash((Object)this.direction, (int)super.computeHashCode()));
    }

    @Override
    public String formatWKT(Formatter formatter) {
        formatter.append(this.direction);
        return "AXIS";
    }

    static {
        DefaultCoordinateSystemAxis.ALTITUDE.opposite = DEPTH = new DefaultCoordinateSystemAxis(73, "d", AxisDirection.DOWN, (Unit<?>)SI.METRE);
        DefaultCoordinateSystemAxis.DEPTH.opposite = ALTITUDE;
        GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(116, "r", AxisDirection.UP, (Unit<?>)SI.METRE);
        SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(280, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(279, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.EAST, (Unit<?>)SI.METRE);
        Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.NORTH, (Unit<?>)SI.METRE);
        Z = new DefaultCoordinateSystemAxis(-1, "z", AxisDirection.UP, (Unit<?>)SI.METRE);
        GEOCENTRIC_X = new DefaultCoordinateSystemAxis(118, "X", AxisDirection.GEOCENTRIC_X, (Unit<?>)SI.METRE);
        GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(119, "Y", AxisDirection.GEOCENTRIC_Y, (Unit<?>)SI.METRE);
        GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(120, "Z", AxisDirection.GEOCENTRIC_Z, (Unit<?>)SI.METRE);
        EASTING = new DefaultCoordinateSystemAxis(88, "E", AxisDirection.EAST, (Unit<?>)SI.METRE);
        DefaultCoordinateSystemAxis.EASTING.opposite = WESTING = new DefaultCoordinateSystemAxis(328, "W", AxisDirection.WEST, (Unit<?>)SI.METRE);
        DefaultCoordinateSystemAxis.WESTING.opposite = EASTING;
        NORTHING = new DefaultCoordinateSystemAxis(206, "N", AxisDirection.NORTH, (Unit<?>)SI.METRE);
        DefaultCoordinateSystemAxis.NORTHING.opposite = SOUTHING = new DefaultCoordinateSystemAxis(276, "S", AxisDirection.SOUTH, (Unit<?>)SI.METRE);
        DefaultCoordinateSystemAxis.SOUTHING.opposite = NORTHING;
        TIME = new DefaultCoordinateSystemAxis(296, "t", AxisDirection.FUTURE, NonSI.DAY);
        COLUMN = new DefaultCoordinateSystemAxis(36, "i", AxisDirection.COLUMN_POSITIVE, Unit.ONE);
        ROW = new DefaultCoordinateSystemAxis(256, "j", AxisDirection.ROW_POSITIVE, Unit.ONE);
        DISPLAY_X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.DISPLAY_RIGHT, Unit.ONE);
        DISPLAY_Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.DISPLAY_DOWN, Unit.ONE);
        UNDEFINED = new DefaultCoordinateSystemAxis(307, "?", AxisDirection.OTHER, Unit.ONE);
        UNITIALIZED = new DefaultCoordinateSystemAxis("Undefined", "?", AxisDirection.OTHER, Unit.ONE);
        ALIASES = new HashMap<String, CoordinateSystemAxis>(12);
        ALIASES.put("lat", GEODETIC_LATITUDE);
        ALIASES.put("latitude", GEODETIC_LATITUDE);
        ALIASES.put("geodetic latitude", GEODETIC_LATITUDE);
        ALIASES.put("lon", GEODETIC_LONGITUDE);
        ALIASES.put("long", GEODETIC_LONGITUDE);
        ALIASES.put("longitude", GEODETIC_LONGITUDE);
        ALIASES.put("geodetic longitude", GEODETIC_LONGITUDE);
    }
}

