/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.transform;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.geotoolkit.parameter.FloatParameter;
import org.geotoolkit.parameter.ParameterGroup;
import org.geotoolkit.referencing.operation.provider.Logarithmic;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform1D;
import org.geotoolkit.referencing.operation.transform.ExponentialTransform1D;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

@Immutable
public class LogarithmicTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    private static final double EPS = 1.0E-8;
    public final double base;
    final double lnBase;
    public final double offset;
    private MathTransform1D inverse;

    private LogarithmicTransform1D(ExponentialTransform1D exponentialTransform1D) {
        this.base = exponentialTransform1D.base;
        this.lnBase = exponentialTransform1D.lnBase;
        this.offset = -Math.log(exponentialTransform1D.scale) / this.lnBase;
        this.inverse = exponentialTransform1D;
    }

    protected LogarithmicTransform1D(double d, double d2) {
        this.base = d;
        this.offset = d2;
        this.lnBase = Math.log(d);
    }

    static LogarithmicTransform1D create(ExponentialTransform1D exponentialTransform1D) {
        if (Math.abs(exponentialTransform1D.base - 10.0) < 1.0E-8) {
            return new Base10(exponentialTransform1D);
        }
        return new LogarithmicTransform1D(exponentialTransform1D);
    }

    public static MathTransform1D create(double d) {
        return LogarithmicTransform1D.create(d, 0.0);
    }

    public static MathTransform1D create(double d, double d2) {
        if (d == Double.POSITIVE_INFINITY || Math.abs(d) <= 1.0E-8) {
            return LinearTransform1D.create(0.0, d2);
        }
        if (Math.abs(d - 10.0) < 1.0E-8) {
            return new Base10(d2);
        }
        return new LogarithmicTransform1D(d, d2);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Logarithmic.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), new FloatParameter(Logarithmic.BASE, this.base), new FloatParameter(Logarithmic.OFFSET, this.offset));
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double d) {
        return 1.0 / (this.lnBase * d);
    }

    double log(double d) {
        return Math.log(d) / this.lnBase;
    }

    @Override
    public double transform(double d) {
        return Math.log(d) / this.lnBase + this.offset;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n >= n2) {
            while (--n3 >= 0) {
                dArray2[n2++] = Math.log(dArray[n++]) / this.lnBase + this.offset;
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                dArray2[--n2] = Math.log(dArray[--n]) / this.lnBase + this.offset;
            }
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n >= n2) {
            while (--n3 >= 0) {
                fArray2[n2++] = (float)(Math.log(fArray[n++]) / this.lnBase + this.offset);
            }
        } else {
            n += n3;
            n2 += n3;
            while (--n3 >= 0) {
                fArray2[--n2] = (float)(Math.log(fArray[--n]) / this.lnBase + this.offset);
            }
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            fArray[n2++] = (float)(Math.log(dArray[n++]) / this.lnBase + this.offset);
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            dArray[n2++] = Math.log(fArray[n++]) / this.lnBase + this.offset;
        }
    }

    @Override
    final MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        if (mathTransform instanceof LinearTransform) {
            LinearTransform1D linearTransform1D = (LinearTransform1D)mathTransform;
            if (bl) {
                if (linearTransform1D.offset == 0.0 && linearTransform1D.scale > 0.0) {
                    return LogarithmicTransform1D.create(this.base, Math.log(linearTransform1D.scale) / this.lnBase + this.offset);
                }
            } else {
                double d = Math.pow(this.base, 1.0 / linearTransform1D.scale);
                if (!Double.isNaN(d)) {
                    return LogarithmicTransform1D.create(d, linearTransform1D.scale * this.offset + linearTransform1D.offset);
                }
            }
        } else if (mathTransform instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)mathTransform).concatenateLog(this, !bl);
        }
        return super.concatenate(mathTransform, bl);
    }

    @Override
    protected int computeHashCode() {
        return Utilities.hash((double)this.base, (int)Utilities.hash((double)this.offset, (int)super.computeHashCode()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            LogarithmicTransform1D logarithmicTransform1D = (LogarithmicTransform1D)object;
            return Utilities.equals((double)this.base, (double)logarithmicTransform1D.base) && Utilities.equals((double)this.offset, (double)logarithmicTransform1D.offset);
        }
        return false;
    }

    private static final class Base10
    extends LogarithmicTransform1D {
        private static final long serialVersionUID = -5435804027536647558L;

        Base10(ExponentialTransform1D exponentialTransform1D) {
            super(exponentialTransform1D);
        }

        protected Base10(double d) {
            super(10.0, d);
        }

        @Override
        double log(double d) {
            return Math.log10(d);
        }

        @Override
        public double transform(double d) {
            return Math.log10(d) + this.offset;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            if (dArray != dArray2 || n >= n2) {
                while (--n3 >= 0) {
                    dArray2[n2++] = Math.log10(dArray[n++]) + this.offset;
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    dArray2[--n2] = Math.log10(dArray[n++]) + this.offset;
                }
            }
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            if (fArray != fArray2 || n >= n2) {
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(Math.log10(fArray[n++]) + this.offset);
                }
            } else {
                n += n3;
                n2 += n3;
                while (--n3 >= 0) {
                    fArray2[--n2] = (float)(Math.log10(fArray[n++]) + this.offset);
                }
            }
        }

        @Override
        public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
            while (--n3 >= 0) {
                fArray[n2++] = (float)(Math.log10(dArray[n++]) + this.offset);
            }
        }

        @Override
        public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
            while (--n3 >= 0) {
                dArray[n2++] = Math.log10(fArray[n++]) + this.offset;
            }
        }
    }
}

